import platform

from lib_create_env import lib_generate_install_methods

system_str = platform.system()


INSTALLS = [ #(key,method, option_str, dict_extra_env)
    'LXML',
    'PSYCOPG2',
    'MYSQL',
    'SOUTH',
    'PIL', 
    'DJANGO',
    'DJANGO-EXTENSIONS',
    'DJANGO-REGISTRATION',
    'DJANGO-TAGGING',
    'HTTPLIB2',
    'OAUTH2',
    'SETUPTOOLS_HG',
    'WSGIREF',
    'DJANGO-OAUTH-PLUS',
    'OPENID',
    'DJANGO_OPENID_CONSUMER',
    'SOCIAL_AUTH',
    'DJANGO_GUARDIAN',
    'SORL_THUMBNAIL',
    'HAYSTACK',
    'REQUESTS',
    'PYELASTICSEARCH',
    'WHOOSH',
    'MIMEPARSE',
    'PYTHON-DATEUTIL',
    'PYYAML',
    'PYTHON-DIGEST',
    'DJANGO-TASTYPIE',
]

if system_str == "Linux":
    INSTALLS.insert(2, 'DISTRIBUTE')

OPTIONS_TO_ADD = ['clear', 'type_install=local', 'unzip_setuptools']
if system_str != 'Linux':
    OPTIONS_TO_ADD.append('use_distribute')

def generate_install_methods(path_locations, src_base, Logger, call_subprocess):    
    return lib_generate_install_methods(path_locations, src_base, Logger, call_subprocess, INSTALLS, OPTIONS_TO_ADD)
