from django import forms
from django.utils.translation import ugettext_lazy as _
from django.contrib.auth.models import User, Group
from django.forms.widgets import MultipleHiddenInput
from ldt.forms import widgets as ldt_widgets
from models import Project, Content, Media
from utils import generate_uuid

# This class should be moved somewhere else
class LazyMultipleChoiceField(forms.MultipleChoiceField):
    
    # Should do some checking here
    def validate(self, value):
        pass    

class ShareForm(forms.ModelForm):
    read_list = LazyMultipleChoiceField(required=False, widget=MultipleHiddenInput())
    write_list = LazyMultipleChoiceField(required=False, widget=MultipleHiddenInput()) 

    def clean(self):
        read_list = self.data.getlist("read_list")
        write_list = self.data.getlist("write_list")
        
        elems = read_list + write_list
        users = [e.split('-')[0] for e in elems if e.split('-')[1] == 'user' ]
        groups = [e.split('-')[0] for e in elems if e.split('-')[1] == 'group' ]
        
        users = User.objects.filter(id__in=users)
        groups = Group.objects.filter(id__in=groups)
        
        def create_real_lists(list, users, groups):
            new_list = []
            for e in list:
                id, cls_name = e.split('-')
                if cls_name == 'user':
                    new_list.append(users.get(id=id))
                elif cls_name == 'group':
                    new_list.append(groups.get(id=id))
            return new_list
         
        new_read_list = create_real_lists(read_list, users, groups)
        new_write_list = create_real_lists(write_list, users, groups)

        self.cleaned_data["read_list"] = new_read_list
        self.cleaned_data["write_list"] = new_write_list
        return self.cleaned_data
    

class LdtImportForm(forms.Form):
    importFile = forms.FileField()
    videoPath = forms.CharField(required=False)
    flatten = forms.BooleanField(required=False, initial=True)   
    
class LdtAddForm(ShareForm):
    title = forms.CharField(required=True)
    #contents = forms.ModelMultipleChoiceField(Content.objects.all())
    description = forms.CharField(widget=forms.Textarea, required=False)
    
    # remove contents from exclude list    
    class Meta:
        model = Project
        exclude = ("ldt_id", "ldt", "created_by", "changed_by", "creation_date", "modification_date", "state", "owner", "contents")   

class PermissionForm(forms.Form):
    share = forms.BooleanField(required=False, widget=forms.CheckboxInput(attrs={'class':'checkbox_group'}))
    perms = forms.CharField(required=False, widget=forms.HiddenInput(attrs={'class':'perm_field'})) 
    group = forms.IntegerField(required=False, widget=forms.HiddenInput())

class ReindexForm(forms.Form):
    contents = forms.ModelMultipleChoiceField(Content.objects.all()) #@UndefinedVariable
    index_projects = forms.BooleanField(required=False, initial=False)

class SearchForm(forms.ModelForm):
    search = forms.CharField(label=_("Search"))
    field = forms.ChoiceField([(u"all", _("all")), (u"title", _("title")), (u"abstract", _("resume")), (u"tags", _("tags"))], label=_("Fields"))
    ldt_pres = forms.BooleanField(required=False, initial=True, label=_("Display the results in Lignes De Temps"))

class AddProjectForm (ShareForm):
    title = forms.CharField(widget=forms.TextInput(attrs={'class':'inputbox required'}))
    description = forms.CharField(widget=forms.Textarea, required=False)
    
    class Meta:
        model = Project
        exclude = ("ldt_id", "ldt", "created_by", "changed_by", "creation_date", "modification_date", "state", "owner", "contents")   

class CopyProjectForm (forms.Form):
    title = forms.CharField()
    group = forms.IntegerField()    

class ContentForm(forms.ModelForm):
    #iri_id = forms.CharField(max_length=1024, widget=forms.HiddenInput, initial=generate_uuid)
    iriurl = forms.CharField(max_length=1024, widget=forms.HiddenInput, required=False)
    content_creation_date = forms.SplitDateTimeField(widget=ldt_widgets.LdtSplitDateTime, required=False, label=_("content.content_creation_date"))
    media_input_type = forms.ChoiceField(required=False, label=_("content.media_input_type"), choices=(("upload", _("file_upload")), ("url", _("url")), ("link", _("existing_media")), ("create", _("create_media")), ("none", _("none_media"))))
    groups = forms.ModelMultipleChoiceField(Group.objects.all(), required=False)
    is_public = forms.BooleanField(required=False)  
        
    def clean_iri_id(self):
        data = self.cleaned_data.get('iri_id')
        if not data:
            data = generate_uuid()
        return data
    
    def clean(self):
        cleaned_data = self.cleaned_data
        iriurl_data = cleaned_data.get('iriurl')
        iri_id_data = cleaned_data['iri_id']
        if not iriurl_data:
            iriurl_data = "%s/%s.iri" % (iri_id_data, iri_id_data)    
        cleaned_data['iriurl'] = iriurl_data
        return cleaned_data
    
    class Meta:
        model = Content
        exclude = ("creation_date", "update_date", "authors")
        widgets = {
                   'iri_id': forms.HiddenInput,
        }
        
    class Media:
        css = {
            'all' : ('admin/css/forms.css', 'admin/css/base.css', 'admin/css/widgets.css')
               }
        
class MediaForm(forms.ModelForm):
    
    media_creation_date = forms.SplitDateTimeField(widget=ldt_widgets.LdtSplitDateTime, required=False)
    media_file = forms.FileField(required=False);
    src = forms.CharField(required=False, max_length=1024)

    class Meta:
        model = Media
        exclude = ("creation_date", "update_date", "creator")
    
    class Media:
        css = {
            'all' : ('admin/css/forms.css', 'admin/css/base.css', 'admin/css/widgets.css')
               }
        
class GroupAddForm(forms.ModelForm):
    name = forms.CharField(required=True)
    members_list = forms.ModelMultipleChoiceField(User.objects.all(), required=False, widget=MultipleHiddenInput())
    admin_list = forms.ModelMultipleChoiceField(User.objects.all(), required=False, widget=MultipleHiddenInput())
    
    class Meta:
        model = Group
