"""
This file demonstrates two different styles of tests (one doctest and one
unittest). These will both pass when you run "manage.py test".

Replace these with more appropriate tests for your application.
"""

from ldt.ldt_utils.models import User, Media
from ldt.test.client import Client
from ldt.test.testcases import TestCase

class MediaTest(TestCase):
    
    fixtures = ['base_data.json', 'user_data.json']
    
    def setUp(self):
        self.client = Client()
        User.objects.create_superuser('blop', 'blop@blop.com', 'blop')
        
        _ = self.client.login(username='blop', password='blop')
        
        self.user = User()
        self.user.username = 'blop'
    
    def test_create_media(self):
        self.media1, _ = Media.objects.get_or_create(src = "http://www.youtube.com/watch?v=O2G-PEtyKSY")
        self.media1.id = 1
        self.media1.save()        
        
        self.assertEqual(Media.objects.get(id=self.media1.id), self.media1)
        
    def test_del_media(self):
        self.media2 = Media()
        self.media2.id = 2
        self.media2.save()
        
        self.media2.delete()
        
        with self.assertRaises(Media.DoesNotExist):
            Media.objects.get(id=self.media2.id)
            