import os, logging

SITE_ID = 1

BASE_DIR = os.path.dirname(os.path.abspath(__file__)).rstrip("/")+"/"
BASE_URL = '/~ymh/platform/'
WEB_URL = 'http://localhost'
MEDIA_BASE_URL = BASE_URL + 'static/'
STREAM_URL = MEDIA_BASE_URL + "media/content/"

STREAM_SRC_PREFIX = ""



# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = os.path.abspath(BASE_DIR + "../static/")

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash if there is a path component (optional in other cases).
# Examples: "http://media.lawrence.com", "http://example.com/media/"
MEDIA_URL = MEDIA_BASE_URL

CONTENT_ROOT = MEDIA_ROOT + "/media/content/"
STREAM_PATH = CONTENT_ROOT

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
ADMIN_MEDIA_PREFIX = MEDIA_URL + 'admin/'
LDT_MEDIA_PREFIX = MEDIA_URL + 'ldt/'

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.postgresql_psycopg2', # Add 'postgresql_psycopg2', 'postgresql', 'mysql', 'sqlite3' or 'oracle'.
        'NAME': 'platform',                      # Or path to database file if using sqlite3.
        'USER': 'iri',                      # Not used with sqlite3.
        'PASSWORD': 'iri',                  # Not used with sqlite3.
        'HOST': 'localhost',                      # Set to empty string for localhost. Not used with sqlite3.
        'PORT': '5432',                      # Set to empty string for default. Not used with sqlite3.
    }
}

DEBUG = True
TEMPLATE_DEBUG = DEBUG

LOG_FILE = os.path.abspath(os.path.join(BASE_DIR,"../log/log.txt"))
LOG_LEVEL = logging.DEBUG

INDEX_PATH = os.path.abspath(BASE_DIR + "../index/")


ADMINS = (
    # ('Your Name', 'your_email@domain.com'),
)

MANAGERS = ADMINS

EMAIL_USE_TLS = True
EMAIL_HOST = 'smtp.gmail.com'
EMAIL_HOST_USER = 'iri.ddc@gmail.com'
EMAIL_HOST_PASSWORD = 'ddciripompidou'
EMAIL_PORT = 587 

ACCOUNT_ACTIVATION_DAYS = 7
REGISTRATION_OPEN = False

LDT_MAX_SEARCH_NUMBER = 50
LDT_JSON_DEFAULT_INDENT = 2

EMPTY_MEDIA_EXTERNALID = "EMPTY"