import os
from setuptools import setup, find_packages

ROOT_DIR = os.path.dirname(__file__)
SOURCE_DIR = os.path.join(ROOT_DIR)

version = __import__('ldt').__version__

setup(
    name = 'Ldt',
    version = version,
    author = 'Yves-Marie Haussonne (IRI)',
    author_email = 'contact@iri.centrepompidou.fr',
    packages = find_packages(),
    package_data = {
        '': [
            'media/*',
            'locale/*/LC_MESSAGES/*',
            'templates/ldt/*.html',
            'templates/admin/*.html',
            'templates/cms/admin/cms/page/*.html',
        ]
    },
    scripts  =[],
    url = 'https://www.iri.centrepompidou.fr/dev/hg/platform',
    license = 'LICENSE.txt',
    description = 'Platform ldt',
    long_description = open('README.txt').read(),
    zip_safe = False,
    classifiers = ['Development Status :: 5 - Production/Stable',
                   'Environment :: Web Environment',
                   'Framework :: Django',
                   'Intended Audience :: Developers',
                   'License :: Ceccil-C',
                   'Operating System :: OS Independent',
                   'Programming Language :: Python',
                   'Topic :: Utilities'],
)
