from django.db.models import Manager
from guardian.shortcuts import get_objects_for_user
from utils import get_current_user

class SafeManager(Manager):
    
    def __init__(self, user=None, check_perm=True):
        super(SafeManager, self).__init__()
        self.user = user
        self.check_perm = check_perm
        
    def get_query_set(self):
        if not self.check_perm:
            return super(SafeManager, self).get_query_set()
                                
        if not self.user:
            self.user = get_current_user()
            #raise AttributeError("A user has to be chosen to check permissions.")
        
        perm_name = '%s.view_%s' % (self.model._meta.app_label, self.model.__name__.lower()) 
        
        user_objects = get_objects_for_user(self.user, perm_name, klass=self.model.objects) 
            
        return user_objects
    