from django.contrib import admin
from django.contrib.auth import get_user_model
from django.contrib.auth.models import Group
from guardian.admin import GuardedModelAdmin
from models import GroupProfile

User = get_user_model()

class GroupProfileInline(admin.StackedInline):
    model = GroupProfile

class GroupAdmin(GuardedModelAdmin):
    inlines = [GroupProfileInline, ]


admin.site.unregister(Group)
admin.site.register(Group, GroupAdmin)