# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
from django.contrib.contenttypes.models import ContentType
from django.contrib.auth.models import Permission

class Migration(migrations.Migration):
    
    def add_permission_is_owner_group(apps, schema_editor):
        content_type = ContentType.objects.get(app_label='auth', model='group')
        Permission.objects.create(
            codename='is_owner_group', 
            name='Can add/delete admins to the group',
            content_type=content_type
        )        


    
    dependencies = [
        ('user', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(add_permission_is_owner_group)
    ]
