# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import ldt.text.utils
import taggit.managers


class Migration(migrations.Migration):

    dependencies = [
        ('taggit', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Annotation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('external_id', models.CharField(default=ldt.text.utils.generate_uuid, unique=True, max_length=255, verbose_name='external id')),
                ('uri', models.CharField(max_length=1024, verbose_name='annotation uri')),
                ('title', models.CharField(max_length=1024, null=True, verbose_name='title', blank=True)),
                ('description', models.TextField(null=True, verbose_name='description', blank=True)),
                ('text', models.TextField(null=True, verbose_name='text', blank=True)),
                ('color', models.CharField(max_length=1024, verbose_name='color')),
                ('creator', models.CharField(max_length=1024, null=True, verbose_name='title', blank=True)),
                ('contributor', models.CharField(max_length=1024, null=True, verbose_name='title', blank=True)),
                ('creation_date', models.DateTimeField(auto_now_add=True, verbose_name='creation date')),
                ('update_date', models.DateTimeField(auto_now=True, verbose_name='update date')),
                ('tags_field', taggit.managers.TaggableManager(to='taggit.Tag', through='taggit.TaggedItem', help_text='A comma-separated list of tags.', verbose_name='Tags')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
    ]
