from django.contrib import admin
from django.contrib.auth.admin import UserAdmin
from django.contrib.auth.models import Group
from django.utils.translation import gettext_lazy as _
from guardian.admin import GuardedModelAdmin
from ldt.user.forms import AdminUserCreationForm, AdminUserChangeForm
from ldt.user.models import GroupProfile, LdtUser



class GroupProfileInline(admin.StackedInline):
    model = GroupProfile

class GroupAdmin(GuardedModelAdmin):
    inlines = [GroupProfileInline, ]

class LdtUserAdmin(UserAdmin):
    form = AdminUserChangeForm
    add_form = AdminUserCreationForm
    fieldsets = tuple(list(UserAdmin.fieldsets) + [(_('profile'), {'fields':('language','image')})])

admin.site.unregister(Group)
admin.site.register(Group, GroupAdmin)

admin.site.register(LdtUser, LdtUserAdmin)