from django.core.cache import cache
from guardian.core import ObjectPermissionChecker
from guardian.shortcuts import assign

def get_checker_for(user):
    key_name = 'checker_%s' % user.username
    
    checker = cache.get(key_name)
    if checker:
        return checker
    
    checker = ObjectPermissionChecker(user)
    cache.set(key_name, checker, 30)
    return checker


def assign(perm, user_or_group, object):
    assign(perm, user_or_group, object)
    
    if hasattr('username', user_or_group):
        key = 'checker_%s' % user_or_group.username
    else:
        key = 'checker_%s' % user_or_group.name
        
    cache.delete('checker_%s' % key)