from django.template import Library
import re

register = Library()


@register.simple_tag
def active(request, css_class, pattern, exact=True):
    """
    a simple tag to test the current path and return a given css class.
    Useful for navigation tabs
    """
    if pattern:
        if exact:
            pattern = "^%s$" % pattern.lstrip("^").rstrip("$")
     
        if re.search(pattern, request.path):
            return css_class
    return ''
