import urlparse
from django.template import Library
from django.template.defaulttags import URLNode, url
from django.contrib.sites.models import Site
import logging


register = Library()

class AbsoluteURLNode(URLNode):
    def render(self, context):
        path = super(AbsoluteURLNode, self).render(context)
        try:
            request=context['request']
            if request.is_secure():
                domain = "https://%s" % Site.objects.get_current().domain
            else:
                domain = "http://%s" % Site.objects.get_current().domain
        except:
            domain = "http://%s" % Site.objects.get_current().domain
        return urlparse.urljoin(domain, path)

@register.simple_tag
def absurl(parser, token, node_cls=AbsoluteURLNode):
    """Just like {% url %} but ads the domain of the current site."""
    node_instance = url(parser, token)
    return node_cls(view_name=node_instance.view_name,
        args=node_instance.args,
        kwargs=node_instance.kwargs,
        asvar=node_instance.asvar)
absurl = register.tag(absurl)    