from django.conf import settings
import lucene

lucene.initVM(lucene.CLASSPATH)

STORE = lucene.SimpleFSDirectory(lucene.File(settings.INDEX_PATH))
ANALYZER = lucene.PerFieldAnalyzerWrapper(lucene.StandardAnalyzer(lucene.Version.LUCENE_CURRENT))
ANALYZER.addAnalyzer("tags", lucene.FrenchAnalyzer(lucene.Version.LUCENE_CURRENT))
ANALYZER.addAnalyzer("title", lucene.FrenchAnalyzer(lucene.Version.LUCENE_CURRENT))
ANALYZER.addAnalyzer("abstract", lucene.FrenchAnalyzer(lucene.Version.LUCENE_CURRENT))
ANALYZER.addAnalyzer("all", lucene.FrenchAnalyzer(lucene.Version.LUCENE_CURRENT))


def get_results_with_context(field, query):
    res = get_results_list(field, query)
    analyzer = lucene.FrenchAnalyzer(lucene.Version.LUCENE_CURRENT)
    searcher = get_searcher()
    formatter = lucene.SimpleHTMLFormatter('<span class="highlight">', '</span>')
    query = get_query_parser(field).parse(query)
    highlighter = lucene.Highlighter(formatter, lucene.QueryScorer (query))
    contexts = []
    
    for i in res:
        doc = searcher.doc(i.doc)  
        ids = {"iri_id":doc.get("iri_id"), "ensemble_id":doc.get("ensemble_id"), "decoupage_id":doc.get("decoupage_id"), "element_id":doc.get("element_id"), "project_id":doc.get("project_id")}     
        segment_title = doc.getField('title').stringValue()
        
        text = doc.getField(field).stringValue()
        ts = analyzer.tokenStream("body", lucene.StringReader(text))
        context = highlighter.getBestFragments(ts, text, settings.LDT_MAX_FRAGMENT_PER_SEARCH, "...")
        
        ids['context'] = context
        ids['segment_title'] = segment_title
        contexts.append(ids)    
    
    searcher.close()
    return contexts

def get_results_list(field, query):
    indexSearcher = get_searcher()
    queryParser = get_query_parser(field)
    queryObj = queryParser.parse(query)
    hits = indexSearcher.search(queryObj, settings.LDT_MAX_SEARCH_NUMBER)
    
    return hits.scoreDocs

def get_writer(new=False):
    lucene.getVMEnv().attachCurrentThread()
    return lucene.IndexWriter(STORE, ANALYZER, new, lucene.IndexWriter.MaxFieldLength.UNLIMITED)

def get_searcher():
    lucene.getVMEnv().attachCurrentThread()
    return lucene.IndexSearcher(STORE)

def get_query_parser(field):
    queryParser = lucene.QueryParser(lucene.Version.LUCENE_30, field, lucene.FrenchAnalyzer(lucene.Version.LUCENE_30))
    queryParser.setDefaultOperator(lucene.QueryParser.Operator.AND)
    return queryParser




