from django.contrib.auth import authenticate, login, logout
from django.contrib.auth.decorators import login_required
from django.contrib.auth.forms import PasswordChangeForm
from django.http import HttpResponse, HttpResponseRedirect
from django.shortcuts import render_to_response
from django.template import RequestContext, loader
from django.utils import simplejson
from django.utils.translation import ugettext as _
from forms import ProfileForm, LanguageChangeForm
from django.views.i18n import set_language

    
@login_required   
def profile(request):
    msg = ''
    user_language = request.user.get_profile().language
    
    if request.method == "POST":
        profile_form = ProfileForm(request.user, request.POST, instance=request.user)                 
        language_form = LanguageChangeForm(request.user, request.POST)
        password_form = PasswordChangeForm(request.user)

        #assert False, "before : %s " % request.user.username 

        if profile_form.is_valid() and language_form.is_valid():
            profile_form.save()
            language_form.save()  
            set_language(request)
            msg = _("Your profile has been updated.")
            user_language = request.user.get_profile().language

            
        #assert False, "after: %s " % request.user.username        
              
    else:
        language_form = LanguageChangeForm()
        profile_form = ProfileForm(instance=request.user)
        password_form = PasswordChangeForm(request.user)
    return render_to_response('ldt/user/change_profile.html', {'profile_form' : profile_form, 'language_form' : language_form, 'password_form' : password_form, 'user_language' : user_language, 'msg' : msg }, context_instance=RequestContext(request))    

    
@login_required   
def password(request):
    msg = ''
    user_language = request.user.get_profile().language
   
    if request.method == "POST":        
        password_form = PasswordChangeForm(request.user, request.POST)
        profile_form = ProfileForm(instance=request.user)
        language_form = LanguageChangeForm()
        if password_form.is_valid():
            password_form.save()
            msg = _("Your password has been updated.")

    else:
        language_form = LanguageChangeForm()
        profile_form = ProfileForm()
        password_form = PasswordChangeForm(request.user)
    return render_to_response('ldt/user/change_profile.html', {'profile_form' : profile_form, 'language_form' : language_form, 'password_form' : password_form, 'user_language' : user_language, 'msg' : msg }, context_instance=RequestContext(request))


def logout_view(request):
    logout(request)
    return HttpResponseRedirect(request.META.get('HTTP_REFERER', '/'))
    #return HttpResponseRedirect(settings.LOGOUT_URL)

    
def login_ajax(request, loginstate_template_name='ldt/user/login_form.html'):
    if request.method == "POST":
        username = request.POST["username"]
        password = request.POST["password"]
        user = authenticate(username=username, password=password)
        error_message = _(u"Sorry, that's not a valid username or password.")
        if user is not None:
            if user.is_active:
                login(request, user)
                context = RequestContext(request, { 'username': user.username, })
                template = loader.get_template(loginstate_template_name)
                html = template.render(context)
                return HttpResponse(simplejson.dumps({'message': u'successful', 'username': user.username, 'html': html, 'reload': request.POST["reload"], }))               
            else:
                return HttpResponse(simplejson.dumps({'message': error_message, }))
        else:
            return HttpResponse(simplejson.dumps({'message': error_message, }))
    return render_to_response('ldt/user/login_ajax.html', context_instance=RequestContext(request))

               
