from django.conf import settings
from django.core.exceptions import MiddlewareNotUsed
from ldt.security.utils import protect_models, unprotect_models

try:
    from threading import local
except ImportError:
    from django.utils._threading_local import local
    
_thread_locals = local()
    
class SecurityMiddleware(object):
    
    def __init__(self):
        if not hasattr(settings, 'USE_GROUP_PERMISSIONS') or not settings.USE_GROUP_PERMISSIONS:
            raise MiddlewareNotUsed()

    def process_request(self, request):    
        protect_models(request.user)      
    
    def process_response(self, request, response):
        unprotect_models()
        
        return response