"""
This middleware changes the request header content type because 
piston does not like 'charset=UTF-8" in PUT request
"""

from django.conf import settings

class PistonPutMiddleware(object):

    def process_request(self, request):
        if request.method in ('PUT') and not 'boundary=' in request.META['CONTENT_TYPE']:
            request.META['CONTENT_TYPE'] = [c.strip() for c in request.META['CONTENT_TYPE'].split(";") ][0]
        return None
#        if request.method == 'PUT' and request.META.has_key('CONTENT_TYPE') :
#            if request.META['CONTENT_TYPE'] == 'application/x-www-form-urlencoded; charset=UTF-8':
#                request.META['CONTENT_TYPE'] = 'application/x-www-form-urlencoded'
#            if request.META['CONTENT_TYPE'] == 'application/json; charset=UTF-8':
#                request.META['CONTENT_TYPE'] = 'application/json'