from django.conf import settings
from django.contrib.auth.decorators import login_required
from django.contrib.auth.models import Group, User
from django.http import HttpResponseServerError
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext
from guardian.shortcuts import get_objects_for_group
from ldt.ldt_utils.models import Content, Project
from ldt.security.utils import add_change_attr





@login_required
def front_home(request):
    # Get the 3 last annotated contents
    last_contents = Content.objects.all()[:3]
    # Get the most annotated contents
    most_contents = Content.objects.all()[4:12]
    # Get the active groups
    active_groups = Group.objects.exclude(name=settings.PUBLIC_GROUP_NAME)[:5]
    
    
    is_gecko = ((request.META['HTTP_USER_AGENT'].lower().find("firefox")) > -1);

    return render_to_response("front/front_home.html",
                              {'last_contents': last_contents, 'most_contents':most_contents, 'active_groups':active_groups,
                               'is_gecko': is_gecko},
                              context_instance=RequestContext(request))


@login_required
def group_info(request, group_id):
    # Get the active group
    group = Group.objects.get(id=group_id)
    # list of contents annotated by the group (or everyone)
    everyone = Group.objects.get(name=settings.PUBLIC_GROUP_NAME)
    content_list = get_objects_for_group(group, 'ldt_utils.view_content') | get_objects_for_group(everyone, 'ldt_utils.view_content')
    # Group's users
    users = User.objects.filter(groups__in=[group])
    
    is_gecko = ((request.META['HTTP_USER_AGENT'].lower().find("firefox")) > -1);

    return render_to_response("front/front_group.html",
                              {'group': group, 'content_list':content_list, 'users':users,
                               'is_gecko': is_gecko},
                              context_instance=RequestContext(request))


    
