from django.conf import settings
from django.core.management.base import BaseCommand
from ldt.ldt_utils.models import Content
from ldt.ldt_utils.stat import update_stat_content, get_empty_stat_vector

class Command(BaseCommand):
    help = 'Computes annotation for all contents'
    
    
    def handle(self, *args, **options):             
       
        size_stat = len(get_empty_stat_vector())
       
        for c in Content.objects.all():
            if len( c.stat_annotation.split(',')) != size_stat:
                c.stat_annotation = [0] * size_stat
                c.save()
            
            update_stat_content(c)
                  
        return None
    