"""
This file demonstrates two different styles of tests (one doctest and one
unittest). These will both pass when you run "manage.py test".

Replace these with more appropriate tests for your application.
"""

from django.test import TestCase
import unittest
import lxml.etree
from models import Project, Content
from ldt.core.models import Owner
from utils import LdtUtils, LdtSearch, create_ldt, create_empty_iri, copy_ldt
import base64
import uuid
import tempfile
from django.contrib.auth.models import *
from views import get_attrib
from django.conf import settings



class SimpleTest(TestCase):
    def test_basic_addition(self):
        """
        Tests that 1 + 1 always equals 2.
        """
        self.failUnlessEqual(1 + 1, 2)

__test__ = {"doctest": """
Another way to test that 1 + 1 is equal to 2.

>>> 1 + 1 == 2
True
"""}



class UtilsTest(unittest.TestCase):
    def setUp(self):
        self.user = Owner()
        self.user.username = "toto"
        self.LU = LdtUtils()
    
        self.project = Project(title="titleproj1", owner=self.user)
        self.project.ldt = '<iri ldtversion="1.0.3" xmlns:dc="http://dublincore.org/documents/dcmi-namespace/"><project id="af3b99e4-b695-11df-bfde-00145ea4a2be" user="admin" title="CA:reponse a TC" abstract=""/> <medias> <media extra="" id="laurentcantet_entrelesmurs" pict="" src="http://amateur.iri.centrepompidou.fr//atelier/static/media/ldt/laurentcantet_entrelesmurs/laurentcantet_entrelesmurs.iri" video="rtmp://media.iri.centrepompidou.fr/ddc_player/video/regardssignes/"/> </medias> <annotations> <content id="laurentcantet_entrelesmurs"> <ensemble id="ens_perso" idProject="fe0d5d4c-2201-11df-8a24-00145ea4a2be" title="Decoupages personnels" author="perso" abstract=""> <decoupage id="c_EFC3FFE7-0204-A086-EBEC-D2A03A0E56CB" author="perso"> <title>CA: prof et admin</title> <abstract/> <elements> <element id="s_442AAB3A-42DA-F9BF-75E7-D2A0663FD5FF" begin="985690" dur="373222" author="" date="2010/09/02" color="16711680" src=""> <title/> <abstract/> <audio source=""/> <tags/> </element> <element id="s_0050F043-3AD2-0A7C-6699-D2A03A1EBA02" begin="5052858" dur="124407" author="" date="2010/09/02" color="10053375" src=""> <title>conseil de classe</title> <abstract>Reprise de la figure precedente</abstract> <audio source="undefined"/> <tags/> </element> </elements> </decoupage> <decoupage id="c_EEEF5C29-86E1-4AAE-E068-04EB5B00E492" author="perso"> <title>TC: prof et admin</title> <abstract/> <elements> <element id="s_880D9D4B-8BC0-BA43-5ECA-04EBA9FC9E59" begin="2426894" dur="141478" author="" date="2010/02/25" color="10053375" src=""> <title>Conseil de classe</title> <abstract/> <audio source=""/> <tags> <tag>Argumentation</tag> </tags> </element> <element id="s_D568A57C-7110-DED2-3165-04EC54387060" begin="5052858" dur="124407" author="" date="2010/02/25" color="10053375" src=""> <title>conseil de classe</title> <abstract>Reprise de la figure precedente</abstract> <audio source="undefined"/> <tags/> </element> </elements> </decoupage> </ensemble> </content> </annotations> <displays> <display id="0" title="Init view" idsel="laurentcantet_entrelesmurs" tc="2426424" zoom="0" scroll="0" infoBAB=""> <audio source=""/> <content id="laurentcantet_entrelesmurs"> <decoupage idens="en_2" id="de_PPP" tagsSelect=""/> <decoupage idens="laurentcantet_entrelesmurs" id="c_14A2E638-1936-97DC-E303-2DBA6A82A8B3" tagsSelect=""/> <decoupage idens="ens_perso" id="c_EEEF5C29-86E1-4AAE-E068-04EB5B00E492" tagsSelect=""/> <decoupage idens="ens_perso" id="c_EFC3FFE7-0204-A086-EBEC-D2A03A0E56CB" tagsSelect=""/> </content> </display> </displays> <edits> <editing id="0" tags=""> <title>Bout a bout 1</title> <abstract/> <edit id="edit1" tags=""> <eList/> <caption/> <audio/> <mList/> </edit> <edit id="edit2" tags=""> <eList/> <caption/> <audio/> <mList/> </edit> </editing> </edits> </iri>'
        self.project.id = "11"
        self.project.ldt_id = str(uuid.uuid1())
        self.project.save()
        
        self.projectcopy = Project(title="the2ndproject")
        self.projectcopy.id = "22"

    def tearDown(self):
        self.project.delete()
        self.projectcopy.delete()
        #self.cont1.delete()
        #self.cont2.delete()

    def test_generate_ldt(self):
        self.cont1 = Content(iriurl="id1/iriurl1")
        self.cont1.iri_id = "id1"
        self.cont1.save()
        
        self.cont2 = Content(iriurl="id2/iriurl2")
        self.cont2.iri_id = "id2"
        self.cont2.save()
        
        self.project.contents.add(self.cont1, self.cont2)
    
        f = tempfile.TemporaryFile(mode='r+')
        self.LU.generateLdt(Content.objects.all(), f)
        f.seek(0)
        ldoc = lxml.etree.parse(f)
        self.assertEqual(ldoc.xpath("/iri/displays/display/content")[9].get("id"), self.cont2.iri_id)
        self.assertEqual(ldoc.xpath("/iri/medias/media")[8].get("id"), self.cont1.iri_id)
        f.close()

    def test_generate_init(self):
        self.cont3 = Content(iriurl="id3/iriurl1")
        self.cont3.iri_id = "id3"
        self.cont3.save()
        
        self.cont4 = Content(iriurl="id4/iriurl2")
        self.cont4.iri_id = "id4"
        self.cont4.save()
        
        self.project.contents.add(self.cont3, self.cont4)
        ldoc = self.LU.generateInit(None, None)
        self.assertEqual(ldoc.xpath("/iri/files/init")[0].tag, "init")
        self.assertEqual(ldoc.xpath("/iri/files/library")[0].tag, "library")
        self.assertEqual(ldoc.xpath("/iri/files/init/file")[0].get("video"), settings.STREAM_URL)

    def test_create_ldt(self):
        self.cont5 = Content(iriurl="id5/iriurl1")
        self.cont5.iri_id = "id5"
        self.cont5.save()
        
        self.cont6 = Content(iriurl="id6/iriurl2")
        self.cont6.iri_id = "id6"
        self.cont6.save()
        
        self.project.contents.add(self.cont5, self.cont6)
        self.project.ldt = ""
        create_ldt(self.project, self.user)
        ldt = lxml.etree.fromstring(self.project.ldt)
        self.assertEqual(ldt.xpath("/iri")[0].tag, "iri")
        self.assertEqual(ldt.xpath("/iri/project")[0].get("title"), self.project.title)
        self.assertEqual(ldt.xpath("/iri/medias/media")[0].get("src"), self.cont5.iri_url())
        self.assertEqual(ldt.xpath("/iri/medias/media")[1].get("id"), self.cont6.iri_id)

    def test_copy_ldt(self):
        self.cont7 = Content(iriurl="id7/iriurl1")
        self.cont7.iri_id = "id7"
        self.cont7.save()
        
        self.cont8 = Content(iriurl="id8/iriurl2")
        self.cont8.iri_id = "id8"
        self.cont8.save()
        
        self.project.contents.add(self.cont7, self.cont8)
        copy_ldt(self.project, self.projectcopy, self.user)
        ldt1 = lxml.etree.fromstring(self.project.ldt)
        ldt2 = lxml.etree.fromstring(self.projectcopy.ldt)
        self.assertTrue(ldt1.xpath("/iri/project")[0].get("id") != ldt2.xpath("/iri/project")[0].get("id"))
        self.assertEqual(ldt1.xpath("/iri/medias/media")[0].get("id"), ldt2.xpath("/iri/medias/media")[0].get("id"))
        self.assertEqual(ldt1.xpath("/iri/annotations/content/ensemble")[0].get("title"), ldt2.xpath("/iri/annotations/content/ensemble")[0].get("title"))
        self.assertEqual(ldt1.xpath("/iri/annotations/content/ensemble/decoupage")[0].get("id"), ldt2.xpath("/iri/annotations/content/ensemble/decoupage")[0].get("id"))
        self.assertEqual(ldt1.xpath("/iri/annotations/content/ensemble/decoupage/title")[1].text, ldt2.xpath("/iri/annotations/content/ensemble/decoupage/title")[1].text.strip("\n\t"))

    def test_create_empty_iri(self):
        self.cont9 = Content(iriurl="id9/iriurl1")
        self.cont9.iri_id = "id9"
        self.cont9.save()
        
        self.cont10 = Content(iriurl="id10/iriurl2")
        self.cont10.iri_id = "id10"
        self.cont10.save()
        
        self.project.contents.add(self.cont9, self.cont10)
        tmp = tempfile.TemporaryFile(mode='r+')
        create_empty_iri(tmp, self.cont9, "admin")
        tmp.seek(0)
        ldoc = lxml.etree.parse(tmp)
        self.assertEqual(ldoc.xpath("/iri/head/meta")[0].get("content"), self.cont9.iri_id)
        self.assertEqual(ldoc.xpath("/iri/body/medias/media/video")[0].get("id"), self.cont9.iri_id)
        tmp.close()
    



class ViewsTest(unittest.TestCase):
    def setUp(self):
        self.project = Project()
        self.project.id = "121"
        self.project.save()
        self.project.ldt = '<iri ldtversion="1.0.3" xmlns:dc="http://dublincore.org/documents/dcmi-namespace/"><project id="af3b99e4-b695-11df-bfde-00145ea4a2be" user="admin" title="CA:reponse a TC" abstract=""/> <medias> <media extra="" id="laurentcantet_entrelesmurs" pict="" src="http://amateur.iri.centrepompidou.fr//atelier/static/media/ldt/laurentcantet_entrelesmurs/laurentcantet_entrelesmurs.iri" video="rtmp://media.iri.centrepompidou.fr/ddc_player/video/regardssignes/"/> </medias> <annotations> <content id="laurentcantet_entrelesmurs"> <ensemble id="ens_perso" idProject="fe0d5d4c-2201-11df-8a24-00145ea4a2be" title="Decoupages personnels" author="perso" abstract=""> <decoupage id="c_EFC3FFE7-0204-A086-EBEC-D2A03A0E56CB" author="perso"> <title>CA: prof et admin</title> <abstract/> <elements> <element id="s_442AAB3A-42DA-F9BF-75E7-D2A0663FD5FF" begin="985690" dur="373222" author="" date="2010/09/02" color="16711680" src=""> <title/> <abstract/> <audio source=""/> <tags/> </element> <element id="s_0050F043-3AD2-0A7C-6699-D2A03A1EBA02" begin="5052858" dur="124407" author="" date="2010/09/02" color="10053375" src=""> <title>conseil de classe</title> <abstract>Reprise de la figure precedente</abstract> <audio source="undefined"/> <tags/> </element> </elements> </decoupage> <decoupage id="c_EEEF5C29-86E1-4AAE-E068-04EB5B00E492" author="perso"> <title>TC: prof et admin</title> <abstract/> <elements> <element id="s_880D9D4B-8BC0-BA43-5ECA-04EBA9FC9E59" begin="2426894" dur="141478" author="" date="2010/02/25" color="10053375" src=""> <title>Conseil de classe</title> <abstract/> <audio source=""/> <tags> <tag>Argumentation</tag> </tags> </element> <element id="s_D568A57C-7110-DED2-3165-04EC54387060" begin="5052858" dur="124407" author="" date="2010/02/25" color="10053375" src=""> <title>conseil de classe</title> <abstract>Reprise de la figure precedente</abstract> <audio source="undefined"/> <tags/> </element> </elements> </decoupage> </ensemble> </content> </annotations> <displays> <display id="0" title="Init view" idsel="laurentcantet_entrelesmurs" tc="2426424" zoom="0" scroll="0" infoBAB=""> <audio source=""/> <content id="laurentcantet_entrelesmurs"> <decoupage idens="en_2" id="de_PPP" tagsSelect=""/> <decoupage idens="laurentcantet_entrelesmurs" id="c_14A2E638-1936-97DC-E303-2DBA6A82A8B3" tagsSelect=""/> <decoupage idens="ens_perso" id="c_EEEF5C29-86E1-4AAE-E068-04EB5B00E492" tagsSelect=""/> <decoupage idens="ens_perso" id="c_EFC3FFE7-0204-A086-EBEC-D2A03A0E56CB" tagsSelect=""/> </content> </display> </displays> <edits> <editing id="0" tags=""> <title>Bout a bout 1</title> <abstract/> <edit id="edit1" tags=""> <eList/> <caption/> <audio/> <mList/> </edit> <edit id="edit2" tags=""> <eList/> <caption/> <audio/> <mList/> </edit> </editing> </edits> </iri>' 
    
        self.cont1 = Content(iriurl="/laurentcantet_entrelesmurs/iriurl1")
        self.cont1.iri_id = 'laurentcantet_entrelesmurs'
        self.cont1.save()
    
        self.cont2 = Content(iriurl="/content_notinldt/iriurl2")
        self.cont2.iri_id = 'content_notinldt'
        self.cont2.save()
        
        self.project.contents.add(self.cont1, self.cont2)

    def tearDown(self):
        self.project.delete()
        ##self.cont1.delete()
        ##self.cont2.delete()

#    def test_get_attrib(self):
#        get_attrib(self.project)
#        ldoc = lxml.etree.fromstring(self.project.ldt)    
#        self.assertEqual(self.project.title, ldoc.xpath("/iri/project")[0].get("title"))
#        self.assertEqual(ldoc.xpath("/iri/medias/media")[0].get('id'), self.cont1.iri_id)
#        self.assertTrue(self.cont2.iri_id not in self.project.contents.all())
