from ldt.security.utils import protect_models, unprotect_models, _thread_locals, set_current_user, del_current_user

class SecurityMiddleware(object):
    
    def process_request(self, request):
        if not hasattr(_thread_locals, 'user'):
            set_current_user(request.user)
            protect_models()
    
    def process_response(self, request, response):
        
        if hasattr(_thread_locals, 'user'):            
            unprotect_models()
            del_current_user()
                
        return response
    