from django.conf import settings
from ldt.ldt_utils.models import Project


def group_security(func):
    def wrapper(request, *args, **kwargs):
        if settings.USE_GROUP_PERMISSIONS:
            if not request.user:
                raise AttributeError("A user should be set in the request.")

            Project.objects_safe.check_perm_for(request.user)
            old_project_manager = Project.objects
            Project.objects = Project.objects_safe
            
            response = func(request, *args, **kwargs)
            
            Project.objects = old_project_manager            
            Project.objects_safe.stop_checking()
            
        else:
            response = func(request, *args, **kwargs)
        return response
    return wrapper
        