import logging
from django.conf import settings


# EMAIL_HOST='smtp.gmail.com'
# EMAIL_HOST_USER = 'wujingwen1112@gmail.com'
# EMAIL_HOST_PASSWORD='jingwen1112'
# EMAIL_PORT='587'
# EMAIL_USE_TLS = True
#DEFAULT_FROM_EMAIL = "admin@domain.com"
#SERVER_EMAIL = "admin@domain.com"

INSTALLED_APPS = (
    'django_extensions',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.messages',
    'django.contrib.admin',
    'registration',
    'tagging',
    'haystack',
    'ldt',
    'ldt.core',
    'ldt.ldt_utils',
    'ldt.text',
    'ldt.user',
    'ldt.management',
    'ldt.indexation',
    'oauth_provider',
    'django_openid_consumer',
    'social_auth',
    'south',
    'guardian',
    'sorl.thumbnail',
    'tastypie',
)

MIDDLEWARE_CLASSES = (
    'django.middleware.cache.UpdateCacheMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.cache.FetchFromCacheMiddleware',
    'ldt.ldt_utils.middleware.swfupload.SWFUploadMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.middleware.locale.LocaleMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django_openid_consumer.middleware.OpenIDMiddleware',
    'ldt.ldt_utils.middleware.userprofile.LanguageMiddleware',
)



WEB_URL = getattr(settings, 'WEB_URL', '')
WEB_AUTH = getattr(settings, 'WEB_AUTH', None)
BASE_URL = getattr(settings, 'BASE_URL', '')
STATIC_URL = getattr(settings, 'STATIC_URL', '')
MEDIA_URL = getattr(settings, 'MEDIA_URL', '')
MEDIA_ROOT = getattr(settings, 'MEDIA_ROOT', '')
SITE_ID = getattr(settings, 'SITE_ID', 1)
DEBUG = getattr(settings, 'DEBUG', True)
MANAGERS = settings.MANAGERS
INSTALLED_APPS = settings.INSTALLED_APPS
LANGUAGES = settings.LANGUAGES
DECOUPAGE_BLACKLIST = getattr(settings, 'DECOUPAGE_BLACKLIST', 'de_PPP')
STREAM_URL = getattr(settings, 'STREAM_URL', '')
STREAM_PATH = getattr(settings, 'STREAM_PATH', '')
STREAM_SRC_PREFIX = getattr(settings, 'STREAM_SRC_PREFIX', '')
LOG_FILE = getattr(settings, 'LOG_FILE', '')
LOG_LEVEL = getattr(settings, 'LOG_LEVEL', logging.INFO)
EMPTY_MEDIA_EXTERNALID = getattr(settings, 'EMPTY_MEDIA_EXTERNALID', None)

ADMIN_MEDIA_PREFIX = getattr(settings, 'ADMIN_MEDIA_PREFIX', None)

TEST_WEBSERVER_ADDRPORT = getattr(settings, 'TEST_WEBSERVER_ADDRPORT', '127.0.0.1:8000')

ACCOUNT_ACTIVATION_DAYS = getattr(settings, 'ACCOUNT_ACTIVATION_DAYS', 7)
LDT_MEDIA_PREFIX = getattr(settings, 'LDT_MEDIA_PREFIX', MEDIA_URL + 'ldt/')
LDT_MAX_SEARCH_NUMBER = 50
LDT_MAX_FRAGMENT_PER_SEARCH = 3
LDT_RESULTS_PER_PAGE = 1
LDT_JSON_DEFAULT_INDENT = 2
LDT_MAX_CONTENTS_PER_PAGE = 10
LDT_MAX_PROJECTS_PER_PAGE = 10
LDT_FRONT_MEDIA_PER_PAGE = 9

AUTO_INDEX_AFTER_SAVE = getattr(settings, 'AUTO_INDEX_AFTER_SAVE', True)

WEB_VERSION = getattr(settings, 'WEB_VERSION', '')
ANONYOUS_USER_ID = -1
USE_GROUP_PERMISSIONS = ['Project', 'Content'] 
PUBLIC_GROUP_NAME = 'everyone'

DEFAULT_CONTENT_ICON = "thumbnails/contents/content_default_icon.png"
DEFAULT_PROJECT_ICON = "thumbnails/projects/project_default_icon.png"
DEFAULT_USER_ICON = "thumbnails/users/user_default_icon.png"
DEFAULT_GROUP_ICON = "thumbnails/groups/group_default_icon.png"

# force settings value
if(not hasattr(settings, 'MAX_TAG_LENGTH') or getattr(settings, 'MAX_TAG_LENGTH') > 255):
    setattr(settings, 'MAX_TAG_LENGTH', 255)

EXTERNAL_STREAM_SRC = getattr(settings, 'EXTERNAL_STREAM_SRC', ['youtube.com', 'dailymotion.com', 'vimeo.com'])

HAYSTACK_CONNECTIONS = {
    'default': {
        'ENGINE': 'haystack.backends.simple_backend.SimpleEngine',
    },
}

