import os
from setuptools import setup, find_packages

ROOT_DIR = os.path.dirname(__file__)
SOURCE_DIR = os.path.join(ROOT_DIR)

version = __import__('ldt').__version__

packages, data_files = [], []

for dirpath, dirnames, filenames in os.walk(django_dir):
    # Ignore dirnames that start with '.'
    for i, dirname in enumerate(dirnames):
        if dirname.startswith('.'): del dirnames[i]
    if '__init__.py' in filenames:
        packages.append('.'.join(fullsplit(dirpath)))
    elif filenames:
        data_files.append([dirpath, [os.path.join(dirpath, f) for f in filenames]])

setup(
    name = 'Ldt',
    version = version,
    author = 'Yves-Marie Haussonne (IRI)',
    author_email = 'contact@iri.centrepompidou.fr',
    packages = packages,
    data_files = data_files,
#    package_data = {
#        '': [
#            'media/*',
#            'locale/*/LC_MESSAGES/*',
#            'templates/ldt/*.html',
#            'templates/admin/*.html',
#            'templates/cms/admin/cms/page/*.html',
#       ]
#    },
    scripts  =[],
    url = 'https://www.iri.centrepompidou.fr/dev/hg/platform',
    license = 'LICENSE.txt',
    description = 'Platform ldt',
    long_description = open('README.txt').read(),
    zip_safe = False,
    classifiers = ['Development Status :: 5 - Production/Stable',
                   'Environment :: Web Environment',
                   'Framework :: Django',
                   'Intended Audience :: Developers',
                   'License :: Ceccil-C',
                   'Operating System :: OS Independent',
                   'Programming Language :: Python',
                   'Topic :: Utilities'],
)
