from django.contrib.auth.models import Group
from guardian.shortcuts import assign, remove_perm

def assign_project_to_groups(project, permissions):
    for elem in permissions:
        group = Group.objects.get(id=elem['group'])
        if elem['share']:
            assign('view_project', group, project)
            if elem['perms'] == 'write':
                assign('change_project', group, project)
        else:
            remove_perm('view_project', group, project)
            remove_perm('change_project', group, project) 
