import sys
import os
import os.path
import shutil
import tarfile
import zipfile
import urllib
import platform
import patch
import logging

class ResourcesEnv(object):

    def __init__(self, src_base):
        self.src_base = src_base
        self.URLS = {}
        self.__init_url()
        self.NORMAL_INSTALL = []
        self.__init_normal_install()

    def get_src_base_path(self, fpath):
        return os.path.abspath(os.path.join(self.src_base, fpath)).replace("\\","/")
    
    def __add_package_def(self, key, setup, url, local):
        self.URLS[key] = {'setup':setup, 'url':url, 'local':self.get_src_base_path(local)}

    def __init_url(self):
        self.__add_package_def('DISTRIBUTE', setup='distribute', url='http://pypi.python.org/packages/source/d/distribute/distribute-0.6.14.tar.gz', local="distribute-0.6.14.tar.gz")
        self.__add_package_def('MERCURIAL', setup='mercurial', url='http://pypi.python.org/packages/source/d/mercurial/mercurial-1.7.5.tar.gz', local="mercurial-1.7.5.tar.gz")
        self.__add_package_def('SETUPTOOLS-HG', setup='mercurial_hg', url='http://pypi.python.org/packages/source/s/setuptools_hg/setuptools_hg-0.2.tar.gz', local="setuptools_hg-0.2.tar.gz")


    def __init_normal_install(self):
        system_str = platform.system()
        self.NORMAL_INSTALL = [ #(key,method, option_str, extra_env)
            ('DISTRIBUTE', 'pip', None, None),
            ('MERCURIAL', 'pip', None, None),
            ('SETUPTOOLS-HG', 'pip', None, None), 
        ]

def extend_parser(parser):
    
    parser.add_option(
        '--index-url',
        metavar='INDEX_URL',
        dest='index_url',
        default='http://pypi.python.org/simple/',
        help='base URL of Python Package Index')
    parser.add_option(
        '--type-install',
        metavar='type_install',
        dest='type_install',
        default='local',
        help='type install : local, url, setup')
    parser.add_option(
        '--ignore-packages',
        metavar='ignore_packages',
        dest='ignore_packages',
        default=None,
        help='list of comma separated keys for package to ignore')


def adjust_options(options, args):
    pass


def after_install(options, home_dir):
    global RES_ENV
    #global path_locations
    home_dir, lib_dir, inc_dir, bin_dir = path_locations(home_dir)
    base_dir = os.path.dirname(home_dir)
    src_dir = os.path.join(home_dir, 'src')
    tmp_dir = os.path.join(home_dir, 'tmp')
    ensure_dir(src_dir)
    ensure_dir(tmp_dir)
    system_str = platform.system()
    
    res_source_key = options.type_install
    
    ignore_packages = []
    
    if options.ignore_packages :
        ignore_packages = options.ignore_packages.split(",")
    
    logger.indent += 2
    try:
        
        if 'PYLUCENE' not in ignore_packages and system_str != "Windows":
            #get pylucene
            logger.notify("Get Pylucene from %s " % RES_ENV.URLS['PYLUCENE'][res_source_key])
            pylucene_src = os.path.join(src_dir,"pylucene.tar.gz")
            if res_source_key == 'local':
                shutil.copy(RES_ENV.URLS['PYLUCENE'][res_source_key], pylucene_src)
            else:
                urllib.urlretrieve(RES_ENV.URLS['PYLUCENE'][res_source_key], pylucene_src)
            tf = tarfile.open(pylucene_src,'r:gz')
            pylucene_base_path = os.path.join(src_dir,"pylucene") 
            logger.notify("Extract Pylucene to %s " % pylucene_base_path)
            tf.extractall(pylucene_base_path)
            tf.close()
            
            pylucene_src_path = os.path.join(pylucene_base_path, os.listdir(pylucene_base_path)[0])
            jcc_src_path = os.path.abspath(os.path.join(pylucene_src_path,"jcc"))
            
            #install jcc
    
            #patch for linux
            if system_str == 'Linux' :
                olddir = os.getcwd()
                patch_dest_path = os.path.join(lib_dir,'site-packages','setuptools-0.6c11-py'+'%s.%s' % (sys.version_info[0], sys.version_info[1])+'.egg')
                if os.path.isfile(patch_dest_path):
                    # must unzip egg
                    # rename file and etract all
                    shutil.move(patch_dest_path, patch_dest_path + ".zip")
                    zf = zipfile.ZipFile(patch_dest_path + ".zip",'r')
                    zf.extractall(patch_dest_path)
                    os.remove(patch_dest_path + ".zip")
                logger.notify("Patch jcc : %s " % (patch_dest_path))
                os.chdir(patch_dest_path)
                p = patch.fromfile(os.path.join(jcc_src_path,"jcc","patches","patch.43.0.6c11"))
                p.apply()
                os.chdir(olddir)
    
            logger.notify("Install jcc")
            call_subprocess([os.path.abspath(os.path.join(home_dir, 'bin', 'python')), 'setup.py', 'install'],
                            cwd=jcc_src_path,
                            filter_stdout=filter_python_develop,
                            show_stdout=True)
            #install pylucene
            
            logger.notify("Install pylucene")
            #modify makefile
            makefile_path = os.path.join(pylucene_src_path,"Makefile")
            logger.notify("Modify makefile %s " % makefile_path)
            shutil.move( makefile_path, makefile_path+"~" )
    
            destination= open( makefile_path, "w" )
            source= open( makefile_path+"~", "r" )
            destination.write("PREFIX_PYTHON="+os.path.abspath(home_dir)+"\\n")
            destination.write("ANT=ant\\n")
            destination.write("PYTHON=$(PREFIX_PYTHON)/bin/python\\n")
            
            if system_str == "Darwin":
                if sys.version_info >= (2,6):
                    destination.write("JCC=$(PYTHON) -m jcc.__main__ --shared --arch x86_64 --arch i386\\n")
                else:
                    destination.write("JCC=$(PYTHON) -m jcc --shared --arch x86_64 --arch i386\\n")
                destination.write("NUM_FILES=2\\n")
            elif system_str == "Windows":
                destination.write("JCC=$(PYTHON) -m jcc.__main__ --shared --arch x86_64 --arch i386\\n")
                destination.write("NUM_FILES=2\\n")
            else:
                if sys.version_info >= (2,6) and sys.version_info <= (2,7):
                    destination.write("JCC=$(PYTHON) -m jcc.__main__ --shared\\n")
                else:
                    destination.write("JCC=$(PYTHON) -m jcc --shared\\n")
                destination.write("NUM_FILES=2\\n")
            for line in source:
                destination.write( line )
            source.close()
            destination.close()
            os.remove(makefile_path+"~" )
    
            logger.notify("pylucene make")
            call_subprocess(['make'],
                            cwd=os.path.abspath(pylucene_src_path),
                            filter_stdout=filter_python_develop,
                            show_stdout=True)
    
            logger.notify("pylucene make install")
            call_subprocess(['make', 'install'],
                            cwd=os.path.abspath(pylucene_src_path),
                            filter_stdout=filter_python_develop,
                            show_stdout=True)


        if 'PSYCOPG2' not in ignore_packages and system_str == "Windows":
            #get psycopg2
            psycopg2_src = os.path.join(src_dir,"psycopg2.zip")
            shutil.copy(RES_ENV.URLS['PSYCOPG2'][res_source_key], psycopg2_src)
            #extract psycopg2
            zf = zipfile.ZipFile(psycopg2_src)
            psycopg2_base_path = os.path.join(src_dir,"psycopg2")
            zf.extractall(psycopg2_base_path)
            zf.close()
            
            psycopg2_src_path = os.path.join(psycopg2_base_path, os.listdir(psycopg2_base_path)[0])
            shutil.copytree(os.path.join(psycopg2_src_path, 'psycopg2'), os.path.abspath(os.path.join(home_dir, 'Lib', 'psycopg2')))
            shutil.copy(os.path.join(psycopg2_src_path, 'psycopg2-2.0.10-py2.6.egg-info'), os.path.abspath(os.path.join(home_dir, 'Lib', 'site-packages')))

        for key, method, option_str, extra_env in RES_ENV.NORMAL_INSTALL:
            if key not in ignore_packages:
                normal_install(key, method, option_str, extra_env, res_source_key, home_dir, tmp_dir)
                        
        logger.notify("Clear source dir")
        shutil.rmtree(src_dir)

    finally:
        logger.indent -= 2
    script_dir = join(base_dir, bin_dir)
    logger.notify('Run "%s Package" to install new packages that provide builds'
                  % join(script_dir, 'easy_install'))


def normal_install(key, method, option_str, extra_env, res_source_key, home_dir, tmp_dir):
    global logger
    logger.notify("Install %s from %s with %s" % (key,RES_ENV.URLS[key][res_source_key],method))
    if method == 'pip':
        if sys.platform == 'win32':
            args = [os.path.abspath(os.path.join(home_dir, 'Scripts', 'pip')), 'install', '-E', os.path.abspath(home_dir), RES_ENV.URLS[key][res_source_key]]
        else:
            args = [os.path.abspath(os.path.join(home_dir, 'bin', 'pip')), 'install', '-E', os.path.abspath(home_dir), RES_ENV.URLS[key][res_source_key]]
        if option_str :
            args.insert(4,option_str)
        call_subprocess(args,
                cwd=os.path.abspath(tmp_dir),
                filter_stdout=filter_python_develop,
                show_stdout=True,
                extra_env=extra_env)
    else:
        if sys.platform == 'win32':
            args = [os.path.abspath(os.path.join(home_dir, 'Scripts', 'easy_install')), RES_ENV.URLS[key][res_source_key]]
        else:
            args = [os.path.abspath(os.path.join(home_dir, 'bin', 'easy_install')), RES_ENV.URLS[key][res_source_key]]
        if option_str :
            args.insert(1,option_str)
        call_subprocess(args,
                cwd=os.path.abspath(tmp_dir),
                filter_stdout=filter_python_develop,
                show_stdout=True,
                extra_env=extra_env)
    

def ensure_dir(dir):
    global logger
    if not os.path.exists(dir):
        logger.notify('Creating directory %s' % dir)
        os.makedirs(dir)

def filter_python_develop(line):
    global logger
    if not line.strip():
        return Logger.DEBUG
    for prefix in ['Searching for', 'Reading ', 'Best match: ', 'Processing ',
                   'Moving ', 'Adding ', 'running ', 'writing ', 'Creating ',
                   'creating ', 'Copying ']:
        if line.startswith(prefix):
            return Logger.DEBUG
    return Logger.NOTIFY
