from django.core.management.base import BaseCommand
from ldt.ldt_utils.models import Content
from ldt.ldt_utils.stat import update_stat_content
from optparse import make_option

class Command(BaseCommand):
    help = 'Computes annotation volume for a given content'
    
    option_list = BaseCommand.option_list + (
        make_option("-c", "--content",
                  dest="content",
                  action="store",
                  help="The id of the content we want to compute annotation volume on"),
        )
    
    def handle(self, *args, **options):
        parser = self.create_parser("statannotation", "")
        options, args = parser.parse_args()
                
        verbose = (options.verbosity == "2")
       
        id_content = options.content
        if id_content:
            contents = Content.objects.filter(iri_id=id_content)
            if not len(contents):
                print "No content found with iri_id %s" % id_content
                return None
        else:
            contents = Content.objects.all()
            print "analysing all contents"
        
        
        for content in contents:     
            update_stat_content(content)
                  
        return None
    