import logging

from django.core.urlresolvers import reverse_lazy, reverse
from django.http import HttpResponseForbidden
from django.shortcuts import render_to_response
from django.template import RequestContext
from django.utils.translation import ugettext as _

from ldt.ldt_utils.models import Content
from ldt.ldt_utils.views.embed.meta import ConfigView, IframeView
from ldt.ldt_utils.views.embed.utils import get_datas_for_embed


logger = logging.getLogger(__name__)

class ConfigViewV2(ConfigView):
    template_name = "ldt/ldt_utils/embed/v2/mdplayer_config.html"
    iframe_base_url = reverse_lazy("embed_iframe_v2", urlconf="ldtplatform.urls")
    
class IframeViewV2(IframeView):
    template_name = "ldt/ldt_utils/embed/v2/iframe.html"
    iframe_base_url = reverse_lazy("embed_iframe_v2", urlconf="ldtplatform.urls")
    
    def get(self, request):
        content_id = request.GET.get("content_id")
        project_id = request.GET.get("project_id")
        if not project_id:
            try:
                content = Content.safe_objects.get(iri_id=content_id)
            except:
                return HttpResponseForbidden(_("The content does not exists or you are not allowed to access this content"))
            project = content.get_or_create_front_project()
            project_id = project.ldt_id
        if not project_id :
            return HttpResponseForbidden(_("Parameters project_id or content_id must be given in the url"))
            
        json_url = reverse("projectjson_id", kwargs={'id':project_id})
        player_id = "player_project_" + project_id
        ldt_id = project_id
        rend_dict = get_datas_for_embed(request, json_url, player_id, ldt_id, self.iframe_base_url)
        
        # Test if concatenated projects has been asked
        concatenate_projects = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("concatenate_projects", "").lower())
        if concatenate_projects:
            json_url = reverse("api_content_all_projects", kwargs={'api_name': '1.0', 'resource_name': 'contents', 'iri_id': content_id})
            # add filter
            group_id = request.GET.get("group")
            if group_id is not None :
                json_url += "?group=" + group_id
            rend_dict["json_url"] = json_url
        
        # Manage iframe options
        if request.GET.has_key("player_height"):
            rend_dict["player_height"]=request.GET.get("player_height")
        else:
            rend_dict["player_height"]=300
        if request.GET.has_key("player_width"):
            rend_dict["player_width"]=request.GET.get("player_width")
        else:
            rend_dict["player_width"]=550
        if request.GET.has_key("polemic"):
            rend_dict["polemic"] = True
            if request.GET.get("polemic") == "all":
                rend_dict["polemic_annotation_types"] = []
            else:
                polemic_annotation_types_list = request.GET.get("polemic").split(",")
                rend_dict["polemic_annotation_types"] = polemic_annotation_types_list
            if request.GET.has_key("polemic_defaultColor"):
                rend_dict["polemic_defaultColor"] = request.GET.get("polemic_defaultColor")
            else:
                rend_dict["polemic_defaultColor"]="585858"
            if request.GET.has_key("polemic_foundColor"):
                rend_dict["polemic_foundColor"] = request.GET.get("polemic_foundColor")
            else:
                rend_dict["polemic_foundColor"]="fc00ff"
            if request.GET.has_key("polemic_okColor"):
                rend_dict["polemic_okColor"] = request.GET.get("polemic_okColor")
            else:
                rend_dict["polemic_okColor"] = "1d973d"
            if request.GET.has_key("polemic_koColor"):
                rend_dict["polemic_koColor"] = request.GET.get("polemic_koColor")
            else:
                rend_dict["polemic_koColor"]="ce0a15"
            if request.GET.has_key("polemic_refColor"):
                rend_dict["polemic_refColor"] = request.GET.get("polemic_refColor")
            else:
                rend_dict["polemic_refColor"] = "c5a62d"
            if request.GET.has_key("polemic_qColor"):
                rend_dict["polemic_qColor"] = request.GET.get("polemic_qColor")
            else:
                rend_dict["polemic_qColor"] = "036aae"
            if request.GET.has_key("polemics_list"):
                try:
                    # Very rough : has to be something like 
                    # [{"name":"OK","keywords":["%2B%2B"],"color":"%23DDDDDD"},{"name":"KO","keywords":["--"],"color":"%23AAAAAA"},{"name":"REF","keywords":["==","http://"],"color":"%23777777"},{"name":"Q","keywords":["?"],"color":"%23333333"}]
                    pd = request.GET.get("polemics_list")
                except:
                    pd = False
                rend_dict["polemics_list"] = pd
            else:
                rend_dict["polemics_list"] = False
            if request.GET.has_key("polemic__max_elements"):
                try:
                    pme = int(request.GET.get("polemic__max_elements"))
                except:
                    pme = 20
                rend_dict["polemic__max_elements"] = pme
            else:
                rend_dict["polemic__max_elements"] = 20
                
        if request.GET.has_key("autostart"):
            rend_dict["autostart"] = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("autostart").lower())
        else : 
            rend_dict["autostart"] = False
        if request.GET.has_key("createannotation"):
            rend_dict["createannotation"] = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("createannotation").lower())
        if request.GET.has_key("show_mic_record"):
            rend_dict["show_mic_record"] = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("show_mic_record").lower())
            if rend_dict["show_mic_record"]:
                rend_dict["createannotation"]=True
            if request.GET.has_key("createannotation_annotation_types"):
                segments_annotation_types_list = request.GET.get("createannotation_annotation_types").split(",")
                rend_dict["createannotation_annotation_types"] = segments_annotation_types_list
            else:
                rend_dict["createannotation_annotation_types"] = False
        rend_dict["createannotation_polemics"] = True
        if request.GET.has_key("createannotation_polemics"):
            rend_dict["createannotation_polemics"] = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("createannotation_polemics").lower())
        if request.GET.has_key("annotations_list"):
            rend_dict["annotations_list"] = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("annotations_list").lower())
            rend_dict["player_width"] = 550
        if request.GET.has_key("tag_titles"):
            rend_dict["tag_titles"] = request.GET.get("tag_titles")
        if request.GET.has_key("sparkline"):
            rend_dict["sparkline"] = request.GET.get("sparkline")
            if request.GET.has_key("sparkline_lineColor"):
                rend_dict["sparkline_lineColor"] = request.GET.get("sparkline_lineColor")
            else:
                rend_dict["sparkline_lineColor"] = "7492b4"
            if request.GET.has_key("sparkline_fillColor"):
                rend_dict["sparkline_fillColor"] = request.GET.get("sparkline_fillColor")
            else:
                rend_dict["sparkline_fillColor"] = "aeaeb8"
        if request.GET.has_key("slideshare"):
            rend_dict["slideshare"] = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("slideshare").lower())
        if request.GET.has_key("social"):
            rend_dict["social"] = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("social").lower())     
            if request.GET.has_key("show_url"):
                rend_dict["show_url"] = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("show_url").lower())
            else:
                rend_dict["show_url"] = True    
            if request.GET.has_key("show_twitter"):
                rend_dict["show_twitter"] = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("show_twitter").lower())     
            else:
                rend_dict["show_twitter"] = True
            if request.GET.has_key("show_fb"):
                rend_dict["show_fb"] = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("show_fb").lower())     
            else:
                rend_dict["show_fb"] = True
            if request.GET.has_key("show_gplus"):
                rend_dict["show_gplus"] = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("show_gplus").lower())     
            else:
                rend_dict["show_gplus"] = True
            if request.GET.has_key("show_mail"):
                rend_dict["show_mail"] = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("show_mail").lower())     
            else:
                rend_dict["show_mail"] = True
        if request.GET.has_key("annotation"):
            rend_dict["annotation"] = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("annotation").lower())
        if request.GET.has_key("tweet"):
            rend_dict["tweet"] ={'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("tweet").lower())
        if request.GET.has_key("segments"):
            rend_dict["segments"] = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("segments").lower())
        else:
            rend_dict["segments"] = True
        if request.GET.has_key("segments_annotation_types"):
            segments_annotation_types_list = request.GET.get("segments_annotation_types").split(",")
            rend_dict["segments_annotation_types"] = segments_annotation_types_list
        else:
            rend_dict["segments_annotation_types"] = "false"
        if request.GET.has_key("multisegments"):
            rend_dict["multisegments"] = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("multisegments").lower())
        if request.GET.has_key("tagcloud"):
            rend_dict["tagcloud"] = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("tagcloud").lower())
        return render_to_response(self.template_name, rend_dict, context_instance=RequestContext(request))