from django.db.models import Manager
from guardian.shortcuts import get_objects_for_user
from utils import get_current_user

class SafeManager(Manager):
    
    def __init__(self, user=None):
        super(SafeManager, self).__init__() 
        if user:
            self.check_perm_for(user)
        else:
            self.user = get_current_user()
    
    def check_perm_for(self, user):
        self.user = user
        
    def stop_checking(self):
        self.user = None
      
    def has_user(self):
        return self.user != None
            
    def get_query_set(self):        
        if not self.has_user():
            return super(SafeManager, self).get_query_set()
        #    raise AttributeError("A user has to be chosen to check permissions.")
        
        perm_name = 'ldt_utils.view_%s' % self.model.__name__.lower() 
        
        # call parent query_set below
        user_objects = get_objects_for_user(self.user, perm_name) 
            
        return user_objects
