$(document).ready(function () {
    $('.graph_annotation').each(function(_i) {
        var _values = this.innerHTML.split(','),
            _nb = _values.length,
            _width = $(this).parent().parent().parent().width() - 8,
            _height = $(this).height(),
            _max = _values.reduce(function(_a,_b) {
                return Math.max(_a,_b);
            }, 1),
            _x = function(_p) {
                return _p * _width / _nb;
            },
            _y = function(_p) {
                return _height * ( 1 - _p / _max );
            },
            _d = _values.map(function(_v,_k) {
                return ( _k == 0 ?
                    "M" + _x(_k) + " " + _y(_v) :
                    "C" + _x(_k-.5) + " " + _y(_values[_k - 1])
                    + " " + + _x(_k-.5) + " " + _y(_v)
                    + " " + + _x(_k) + " " + _y(_v)
                    ) ;
            }).join("") + "L" + _width + " " + _height + "L0 " + _height;
        this.innerHTML = '';
        var _paper = new Raphael(this,_width,_height);
        _paper.rect(0,0,_width,_height).attr({
            "stroke" : "none",
            "fill" : "#ffffff",
            "opacity" : .8,
        });
        _paper.path(_d).attr({
            "fill" : "#adadad",
            "stroke" : "#808080"
        });
    });
});