from django.conf import settings
from social.backends.utils import load_backends


def check_access(user, obj):
    check_meth = getattr(obj, 'check_access', False)
    if check_meth:
        return check_meth(user)
    else:
        return user.is_staff

def social_list():
    """Start list process"""
    l = []
    # We list all wanted backends among all availables 
    for backend in load_backends(settings.AUTHENTICATION_BACKENDS).keys():
        l.append(backend)
    return l