from django.utils import translation
from django.conf import settings

class LanguageMiddleware(object):

    def process_request(self, request):
        
        if request.user.is_authenticated():
            profile = request.user.get_profile()
            request.user.is_regular = profile.is_regular
            language = profile.language
        else:
            language = settings.LANGUAGE_CODE[:2]
            request.user.is_regular = False
            
        translation.activate(language)
        request.LANGUAGE_CODE = translation.get_language()
            
        
            