from django.core.management.base import BaseCommand
from ldt.ldt_utils.models import Content
from ldt.ldt_utils.stat import update_stat_content, get_empty_stat_vector

class Command(BaseCommand):
    help = 'Computes annotation for all contents'
    
    
    def handle(self, *args, **options):             
       
        empty_stat_vector = get_empty_stat_vector()
        size_stat = len(empty_stat_vector)
       
        for c in Content.objects.all():
            if not c.stat_annotation or len( c.stat_annotation.split(',')) != size_stat:
                c.stat_annotation = c.list2str(empty_stat_vector)
                c.save()
            
            update_stat_content(c)
            
        print "Done"                  
        return None
    