from django.conf.urls.defaults import patterns, url
from piston.resource import Resource
from ldt.api.ldt.handlers import ProjectHandler, ContentHandler, SegmentHandler

project_handler = Resource(ProjectHandler, None)
content_handler = Resource(ContentHandler, None)
segment_handler = Resource(SegmentHandler, None)

urlpatterns = patterns('',
    url(r'projects/(?P<project_id>[^/.]+)\.?(?P<emitter_format>.*)$', project_handler, name='project_api'),
    url(r'contents/(?P<iri_id>[^/.]+)\.?(?P<emitter_format>.*)$', content_handler, name='content_api'),
    url(r'segments/(?P<iri_id>.*)/(?P<begin>.*)/(?P<end>.*)$', segment_handler, name='segment_api'),
)


