from django.conf import settings
from django.contrib.auth.models import User, Group
from django.contrib.contenttypes.models import ContentType
from django.core.exceptions import ObjectDoesNotExist
from django.db.models import signals
from ldt.user.models import ldt

    
def post_save_ldt(instance, raw, created, **kwargs):
    signals.post_save.send(sender=User, instance=instance, raw=raw, created=created)     
    
signals.post_save.connect(post_save_ldt, ldt) 

def post_save_user(instance, raw, created, **kwargs):
    if created:
        try:
            owner = instance
        except ObjectDoesNotExist:
            owner = User(instance)
            owner.save() 
    
signals.post_save.connect(post_save_user, User) 
        
def test_ldt():
    if 'ldt.ldt_utils' in settings.INSTALLED_APPS:
        return True
    else:
        return False

def get_content_type_list() :
    content_type_list = []
    return content_type_list


