from django.conf.urls.defaults import url
from ldt.ldt_utils.models import Project
from tastypie.authorization import Authorization
from tastypie.resources import ModelResource


class ProjectResource(ModelResource):
    class Meta:
        allowed_methods = ['get', 'put']
        authorization= Authorization() # BE CAREFUL WITH THAT, it's unsecure
        resource_name = 'projects'
        queryset = Project.objects.all()
    
#    # WARNING : this project API will only accepts and returns json format, no matter format get parameter.
#    def determine_format(self, request):
#        return "application/json"
    
    def override_urls(self):
        # WARNING : in tastypie <= 1.0, override_urls is used instead of prepend_urls. From 1.0.0, prepend_urls will be prefered and override_urls deprecated 
        return [
            url(r"^(?P<resource_name>%s)/(?P<ldt_id>[\w\d_.-]+)/$" % self._meta.resource_name, self.wrap_view('dispatch_detail'), name="api_dispatch_detail"),
        ]
    