from django.conf.urls.defaults import patterns, include, handler500, handler404
from django.contrib import admin
from ldt.text import VERSION_STR
from django.conf import settings


# Uncomment the next two lines to enable the admin:
admin.autodiscover()

urlpatterns = patterns('',
    # Example:

    # Uncomment the admin/doc line below and add 'django.contrib.admindocs' 
    # to INSTALLED_APPS to enable admin documentation:
    # (r'^admin/doc/', include('django.contrib.admindocs.urls')),

    # Uncomment the next line to enable the admin:
    (r'^admin/', include(admin.site.urls)),
    (r'^i18n/', include('django.conf.urls.i18n')),

    (r'^ldt/', include('ldt.ldt_utils.urls')),
    (r'^user/', include('ldt.user.urls')),
    (r'^api/', include('ldt.api.urls')),
    (r'^api/' + VERSION_STR + '/text/', include('ldt.text.urls')),

    (r'^auth_accounts/', include('registration.backends.simple.urls')),

    (r'^accounts/', include('socialauth.urls')),
    (r'^oauth/', include('oauth_provider.urls')),
    (r'^$', 'socialauth.views.signin_complete'),
    
    (r'^/?$', 'django.views.generic.simple.redirect_to', {'url': 'ldt'}),
    #(r'^static/(?P<path>.*)$', 'django.views.static.serve', {'document_root': settings.MEDIA_ROOT}), 
)
