import platform

from lib_create_env import lib_generate_install_methods, install_pylucene, install_psycopg2

system_str = platform.system()


if system_str == 'Linux':
    INSTALLS = [
    ('DISTRIBUTE', 'pip', None, None),
    ]
else:
    INSTALLS = []
    

INSTALLS.extend([ #(key,method, option_str, dict_extra_env)
    ('SETUPTOOLS-HG', 'pip', None, None), 
    ('MYSQL', 'pip', None, None),
    ('PIL', 'easy_install', None, None), 
    ('DJANGO','pip', None, None),
    ('DJANGO-EXTENSIONS', 'pip', None, None),
    ('DJANGO-REGISTRATION', 'easy_install', '-Z', None),
    ('DJANGO-TAGGING', 'pip', None, None),
    ('HTTPLIB2', 'pip', None, None),
    ('OAUTH2', 'easy_install', None, None),
    ('DJANGO-OAUTH-PLUS', 'pip', None, None),
    ('OPENID', 'pip', None, None),
    ('DJANGO_OPENID_CONSUMER', 'pip', None, None),
    ('SOCIAL_AUTH', 'easy_install', None, None),
])

if system_str == 'Windows':
    INSTALLS.extend([
    ('JCC','easy_install',None,None),
    ('PSYCOPG2',install_psycopg2,None,None),
    ('PYLUCENE','easy_install',None,None),
    # We have to install piston after and manually with pip install django-piston-0.2.2-modified.tar.gz, after having launched the virtualenv
    #('DJANGO-PISTON', 'pip', None, None),
    ])
else:
    INSTALLS.extend([
    ('PYLUCENE',install_pylucene,None,None),
    ('PSYCOPG2', 'pip', None, None),
    ('DJANGO-PISTON', 'pip', None, None),
    ])

if system_str == "Darwin":
    INSTALLS.extend([
    ('LXML', 'pip', None, {'STATIC_DEPS': 'true', 'LIBXML2_VERSION': '2.7.8', 'LIBXSLT_VERSION': '1.1.26'}),
    ])
else:
    INSTALLS.extend([
    # We have to install lxml after and manually with easy_install lxml-2.2.2-py2.6-win32.egg, after having launched the virtualenv
    #('LXML', 'easy_install', None, None),
    ])


def generate_install_methods(path_locations, src_base, Logger, call_subprocess):    
    return lib_generate_install_methods(path_locations, src_base, Logger, call_subprocess, INSTALLS)
