from copy import deepcopy #@UnresolvedImport
from django.contrib import admin
from django.contrib.auth.admin import UserAdmin
from django.utils.translation import ugettext as _
from forms import ldtForm
from models import Ldt

class ldtAdmin(UserAdmin):    
    list_display = ('username', 'email', 'first_name', 'last_name')
    
    fieldsets = [
        (None, {'fields': ('username', ('password1', 'password2'))}),
        (_('User details'), {'fields': (('first_name', 'last_name'), 'email')}),
        (_('Groups'), {'fields': ('groups',)}),
        (_('Permissions'), {'fields': ('is_staff', 'user_permissions')}),
    ]    
    form = ldtForm
    model = Ldt
    filter_horizontal = ('user_permissions',)
    
    def get_fieldsets(self, request, obj=None): 
        fieldsets = deepcopy(self.fieldsets)
        if not '/add' in request.path:
            fieldsets[0] = (None, {'fields': ('username',)})
            fieldsets.append((_('Password'), {'fields': ('password1', 'password2'), 'classes': ('collapse',)}))
        return fieldsets
        
    def add_view(self, request):
        return super(UserAdmin, self).add_view(request)               
        
admin.site.unregister(Ldt)
admin.site.register(Ldt, ldtAdmin)
