import os
import sys
import site

def application(environ, start_response):
    os.environ['DJANGO_SETTINGS_MODULE'] = environ['DJANGO_SETTINGS_MODULE']

    prev_sys_path = list(sys.path)

    sys.path.append(environ['PROJECT_PATH'])
    for path in environ.get('PYTHON_PATH', "").split(os.pathsep):
        if path:
            site.addsitedir(path)

    new_sys_path = [] 
    for item in list(sys.path): 
        if item not in prev_sys_path: 
            new_sys_path.append(item) 
            sys.path.remove(item)
    sys.path[:0] = new_sys_path 

    import django.core.handlers.wsgi

    _application = django.core.handlers.wsgi.WSGIHandler()

    return _application(environ, start_response)
