from django.contrib import admin
from django.db import models
from django.conf import settings
from django.contrib.auth.models import User, UserManager
import datetime
            
class Ldt(User):
#    irigroups = models.ManyToManyField(IriGroup, blank=True)
    
    class Meta:
        verbose_name = 'iri user'
        verbose_name_plural = 'iri users'
    
    def __unicode__(self):
        return self.username
        

class LdtManager(UserManager):
    def create_user(self, username, email, password=None):
        "Creates and saves a User with the given username, e-mail and password."
        now = datetime.datetime.now()
        new_user = Ldt(None, username, '', '', email.strip().lower(), 'placeholder', False, True, False, now, now)
        if password:
            new_user.set_password(password)
        else:
            new_user.set_unusable_password()
        new_user.save()
        UserProfile.objects.create(user=new_user)
        return new_user  
    
    
class UserProfile (models.Model): 
    user = models.OneToOneField(User)
    language = models.CharField(max_length=2, default='fr')
    
    
def get_or_create_profile(user):
    try:
        profile = user.get_profile()
    except UserProfile.DoesNotExist:
        profile = UserProfile(user=user)
        profile.save()
    return profile

   
User.objects = LdtManager()
User.objects.contribute_to_class(User, "objects")

admin.site.register(Ldt)
