from ldt.user.models import get_or_create_profile
from django.utils import translation

class LanguageMiddleware(object):

    def process_request(self, request):
        if request.user.is_authenticated():
            language = get_or_create_profile(request.user).language
            translation.activate(language)
            request.LANGUAGE_CODE = translation.get_language()
            