#!/usr/bin/env bash

set -e

if [ $# -eq 0 ]; then
    echo "No argument was provided, looking for mdplayer_path"
    if [ ! -f "mdplayer_path" ]; then
        echo "Error: mdplayer_path file does not exist and no argument was provided"
        exit 1
    fi
    MDPLAYER_PATH=$(cat mdplayer_path)
    if [ -z "$MDPLAYER_PATH" ]; then
        echo "File is empty"
        exit 1
    fi
  else
    MDPLAYER_PATH=$1
fi

echo "Compiling Metadataplayer"

sh $MDPLAYER_PATH/sbin/res/ant/bin/ant -f $MDPLAYER_PATH/sbin/build/client.xml

echo "Copying to Platform :"

echo "  Copying core files and widgets"

cp -R $MDPLAYER_PATH/test/metadataplayer/* ../../src/ldt/ldt/static/ldt/metadataplayer

echo "  Copying JS libs"

cp -R $MDPLAYER_PATH/src/js/libs/*.js ../../src/ldt/ldt/static/ldt/js

echo "  Copying SWF libs"

cp -R $MDPLAYER_PATH/src/js/libs/*.swf ../../src/ldt/ldt/static/ldt/swf
