from django.core.management.base import BaseCommand
from ldt.ldt_utils.models import Content, Project
from ldt.ldt_utils.stat import update_stat_content, update_stat_project

class Command(BaseCommand):
    help = 'Computes annotation for all contents and all projects'
    
    
    def handle(self, *args, **options):             
       
        for proj in Project.objects.all():
            print "Stat for project %s" % proj
            update_stat_project(proj)
        
        # Sets fields nb_annotation and stat_annotation to 0 and 0,0,...,0
        # for contents that do not have annotations
        for content in Content.objects.all():
            if not content.stat_annotation:
                print "Stat for content %s" % content
                update_stat_content(content)
                  
        return None
    