from django.conf import settings
from django.contrib.auth.decorators import login_required
from django.contrib.auth.models import Group
from django.core.urlresolvers import reverse#, resolve
from django.core.paginator import Paginator, InvalidPage, EmptyPage
from django.http import (HttpResponseRedirect, HttpResponseForbidden )
from ldt.indexation import get_results_with_context, highlight_documents
from django.shortcuts import render_to_response
from django.template import RequestContext
from django.template.loader import render_to_string
from django.utils.html import escape
from django.utils.translation import ugettext as _
from ldt.ldt_utils.forms import SearchForm
from ldt.ldt_utils.models import Content, Project, Segment
from ldt.ldt_utils.utils import boolean_convert
from ldt.ldt_utils.projectserializer import ProjectSerializer
from ldt.ldt_utils.views.content import get_contents_page, get_content_tags
from ldt.ldt_utils.views.project import get_projects_page, get_published_projects_page
from ldt.security.utils import add_change_attr, get_userlist
from lxml.html import fragment_fromstring
from operator import itemgetter
from itertools import groupby
import base64
import django.core.urlresolvers
import ldt.auth as ldt_auth
import lxml.etree
import logging
from django.utils.safestring import SafeUnicode, mark_safe



@login_required
def home(request):
    
    num_page = 0
    # Prepare contents pagination
    content_nb, nb_ct_pages, content_list = get_contents_page(num_page, request.user)
    # get list of projects owned by the current user
    project_nb, nb_pj_pages, project_list = get_projects_page(num_page, request.user)
    # Get the all tags list
    tag_cloud = get_content_tags()

    is_gecko = ((request.META['HTTP_USER_AGENT'].lower().find("firefox")) > -1);
    
    # Resolve a URL
    #project_api_view, project_api_args, project_api_kwargs = resolve('/api/ldt/projects/c8448f21-272d-11e1-876b-c8bcc896c290.json')
    #match = resolve('/api/ldt/projects/c8448f21-272d-11e1-876b-c8bcc896c290.json')
    
    # Print the URL pattern that matches the URL
    #print match.url_name
    
    # render list
    return render_to_response("ldt/ldt_utils/workspace.html",
                              {'contents': content_list, 'nb_ct_pages': nb_ct_pages, 'content_nb': content_nb, 'current_content_page':float(num_page),
                               'projects': project_list, 'nb_pj_pages': nb_pj_pages, 'project_nb': project_nb, 'current_project_page':float(num_page),
                               'tag_cloud': tag_cloud, 'is_gecko': is_gecko, #'project_api_url':"match.url_name",
                               #'project_api_view':match.url_name,'project_api_args':"project_api_args",'project_api_kwargs':"project_api_kwargs"
                               },
                              context_instance=RequestContext(request))

    

@login_required
def groups(request): 

    # get list of all published projects
    group_list = request.user.groups.exclude(name=settings.PUBLIC_GROUP_NAME)
    
    group_list = sorted(group_list.all(), key=lambda group: group.name.lower())    
    group_list = add_change_attr(request.user, group_list)

    can_add_group = request.user.has_perm('auth.add_group')
    is_gecko = ((request.META['HTTP_USER_AGENT'].lower().find("firefox")) > -1);
    # render list
    return render_to_response("ldt/ldt_utils/groups.html",
                              {'groups': group_list,
                               'is_gecko': is_gecko,
                               'can_add_group': can_add_group},
                              context_instance=RequestContext(request))


@login_required
def published_project(request): 

    # get list of all published projects
    #project_list = Project.safe_objects.filter(state=2).exclude(title__startswith='front') #@UndefinedVariable
    num_page = 0
    project_nb, nb_pj_pages, project_list = get_published_projects_page(num_page)
    # Search form
    form = SearchForm()

    is_gecko = ((request.META['HTTP_USER_AGENT'].lower().find("firefox")) > -1);
    
    # render list
    return render_to_response("ldt/ldt_utils/published_projects.html",
                              {'projects': project_list, 'nb_pj_pages': nb_pj_pages, 'project_nb': project_nb, 'current_project_page':float(num_page), 
                               'form': form, 'is_gecko': is_gecko},
                              context_instance=RequestContext(request))


def popup_embed(request):

    json_url = request.GET.get("json_url")
    player_id = request.GET.get("player_id")
    ldt_id = request.GET.get("ldt_id")
    
    rend_dict = get_datas_for_embed(request, json_url, player_id, ldt_id)
    
    embed_rendered = dict((typestr,
                           (lambda s:escape(render_to_string("ldt/ldt_utils/partial/embed_%s.html" % (s), rend_dict, context_instance=RequestContext(request))))(typestr))
                           for typestr in ('player', 'seo_body', 'seo_meta', 'links'))
    rend_dict['embed_rendered'] = embed_rendered
    return render_to_response("ldt/ldt_utils/embed_popup.html", rend_dict, context_instance=RequestContext(request))


def iframe_embed(request):

    project_id = request.GET.get("project_id")
    if not project_id:
        content_id = request.GET.get("content_id")
        try:
            content = Content.safe_objects.get(iri_id=content_id)
        except:
            return HttpResponseForbidden(_("The content does not exists or you are not allowed to access this content"))
        project = content.get_or_create_front_project()
        project_id = project.ldt_id
    if not project_id :
        return HttpResponseForbidden(_("Parameters project_id or content_id must be given in the url"))
        
    json_url = reverse("projectjson_id", args=[project_id])
    player_id = "player_project_" + project_id
    ldt_id = project_id
    rend_dict = get_datas_for_embed(request, json_url, player_id, ldt_id)
    
    # Manage iframe options
    if request.GET.has_key("polemic"):
        rend_dict["polemic"] = request.GET.get("polemic")
    if request.GET.has_key("show_mic_record"):
        rend_dict["show_mic_record"] = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("show_mic_record").lower())
    if request.GET.has_key("annotations_list"):
        rend_dict["annotations_list"] = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("annotations_list").lower())
        rend_dict["player_width"] = 550
    
    rend_dict["annotation_block"]= True
    

    return render_to_response("ldt/ldt_utils/embed_iframe.html", rend_dict, context_instance=RequestContext(request))


def get_datas_for_embed(request, json_url, player_id, ldt_id):
    
    project = Project.safe_objects.get(ldt_id=ldt_id); #@UndefinedVariable
    project_contents = project.contents.all()
    content=project_contents[0]
    iframe_url = mark_safe(settings.WEB_URL+settings.BASE_URL+"ldtplatform/ldt/embediframe/?content_id="+content.iri_id)
    external_url = None
    if content.src is not None:
        for external_src in settings.EXTERNAL_STREAM_SRC:
            if  external_src in content.src:
                external_url = content.src
                break
    
    stream_mode = project.stream_mode
    if stream_mode != "video":
        stream_mode = 'radio'

    player_width = 650
    player_height = 480
    
    if stream_mode == 'radio':
        player_height = 1
        
    if not ldt_auth.check_access(request.user, project):
        return HttpResponseForbidden(_("You can not access this project"))

    ps = ProjectSerializer(project, from_contents=True, from_display=True)
    annotations = ps.get_annotations(first_cutting=True)
    rend_dict = {'json_url':json_url, 'player_id':player_id, 'annotations':annotations, 'ldt_id': ldt_id, 'stream_mode': stream_mode, 
                 'player_width': player_width, 'player_height': player_height, 'external_url': external_url,
                 'polemic':False, 'show_mic_record':False, 'annotations_list':False, 'iframe_url':iframe_url}
    
    return rend_dict



def share_filter(request, filter, use_groups=False):
    use_groups = boolean_convert(use_groups)
    if not filter or len(filter) == 0:
        raise AttributeError("filter should be a string")
    
    filter = filter[1:]    
    resp = get_userlist(request.user, filter=filter)
            
    if use_groups:
        groups = Group.objects.filter(name__icontains=filter).exclude(name=settings.PUBLIC_GROUP_NAME)[0:20]

        for g in groups:
            resp.append({'name': g.name, 'id': g.id, 'type': 'group'})
    
    resp = sorted(resp, key=lambda elem: elem['name'].lower())
    
    return render_to_response("ldt/ldt_utils/partial/sharewith.html", {'elem_list' : resp}, context_instance=RequestContext(request))



def search_form(request): 
    form = SearchForm()
    return render_to_response('ldt/ldt_utils/search_form.html', {'form': form} , context_instance=RequestContext(request))

@login_required
def search_index(request):
    language_code = request.LANGUAGE_CODE[:2]
    nb = 0
    results = []
    search = ''
    field = 'all'
    
        
    sform = SearchForm(request.GET)
    if sform.is_valid():
        search = sform.cleaned_data["search"]
        queryStr = base64.urlsafe_b64encode(search.encode('utf8'))
        field = sform.cleaned_data["field"]
        page = sform.cleaned_data["page"] or 1
        ldt_pres = sform.cleaned_data["ldt_pres"]
        
        if ldt_pres:
            url = settings.WEB_URL + django.core.urlresolvers.reverse("ldt.ldt_utils.views.lignesdetemps.search_init", args=[field, queryStr])
            return render_to_response('ldt/ldt_utils/init_ldt_full.html', {'LDT_MEDIA_PREFIX': settings.LDT_MEDIA_PREFIX, 'colorurl': settings.LDT_MEDIA_PREFIX + 'swf/ldt/pkg/color.xml', 'i18nurl': settings.LDT_MEDIA_PREFIX + 'swf/ldt/pkg/i18n', 'language': language_code, 'baseurl': settings.LDT_MEDIA_PREFIX + 'swf/ldt/', 'url': url}, context_instance=RequestContext(request))
        else:                                            
            results, nb = get_search_results(request, search, field, page)            
            
    return render_to_response('ldt/ldt_utils/search_results.html', {'results': results, 'nb_results' : nb, 'search' : search, 'field': field, 'LDT_MEDIA_PREFIX': settings.LDT_MEDIA_PREFIX, 'colorurl': settings.LDT_MEDIA_PREFIX + 'swf/ldt/pkg/color.xml', 'i18nurl': settings.LDT_MEDIA_PREFIX + 'swf/ldt/pkg/i18n', 'language': language_code, 'baseurl': settings.LDT_MEDIA_PREFIX + 'swf/ldt/'}, context_instance=RequestContext(request))
        
 
def get_search_results(request, search, field, page, content_list=None):
    # We parse the author if necessary. For author search to work in every case, we have to transform the query author:cheese shop into author:"CHEESE SHOP"
    if u'author:' in search.lower() :
        sub = search[7:]
        sub = sub.upper()
        if sub[0] != u'"':
            sub = u'"' + sub
        if sub[-1] != u'"':
            sub = sub + u'"'
        search = u'author:' + sub
    results = get_results_with_context(field, search, content_list)
            
    all_segments = Segment.objects.filter(element_id__in=[e['element_id'] for e in results])
    all_projects = Project.objects.filter(ldt_id__in=[e['project_id'] for e in results], state=2)
    all_contents = Content.objects.filter(iri_id__in=[e['iri_id'] for e in results])
    viewable_projects_id = [p.ldt_id for p in all_projects]
           
    complete_results = []           
    results.sort(key=lambda k: k['iri_id'])
           
    for iri_id, item in groupby(results, itemgetter('iri_id')):
        content = filter(lambda e: e.iri_id == iri_id, all_contents)[0]
        if content.description is None:
            content.description = ''
                    
        all_related_segments = list(item)
                
        valid_segments = []
        for s in all_related_segments:
            segment = [seg for seg in all_segments if seg.element_id == s['element_id'] and seg.project_id == s['project_id'] and seg.iri_id == s['iri_id'] and seg.cutting_id == s['cutting_id'] and seg.ensemble_id == s['ensemble_id'] ][0]
                
            segment.score = s['score']
            segment.indexation_id = s['indexation_id']
            segment.context = s['context']
            segment.context_tags = s['tags']
            segment.highlighted = s['highlighted']
                                    
            if not s['project_id']:
                segment.project_id = '_'
                valid_segments.append(segment)
            elif s['project_id'] in viewable_projects_id:
                valid_segments.append(segment)
            
        # If all segments found belong to unpublished projects or projects
        # the current user is not allowed to see
        if not valid_segments:
            continue
            
        score = sum([seg.score for seg in valid_segments])
        complete_results.append({
                                 'list': valid_segments,
                                 'score': score,
                                 'content': content,                                         
                                 })                
      
    complete_results.sort(key=lambda k: k['score'])
    
    paginator = Paginator (complete_results, settings.LDT_RESULTS_PER_PAGE)
    
    try:
        results = paginator.page(page)
    except (EmptyPage, InvalidPage):
        results = paginator.page(paginator.num_pages)
            
    results.object_list = highlight_documents(results.object_list, search, field)
    
    return results, len(complete_results)
   

def loading(request): 
    return render_to_response('ldt/ldt_utils/loading.html', context_instance=RequestContext(request))
   

