"use strict";

var display_state = "player";

function toggle_display() {
    $j.each(["player","ldt_iframe","seo_body","seo_meta","links"], function(i,display_str) {

        var div_selector = "#"+display_str+"_code";
        if(display_str === display_state) {
            $j(div_selector).show();
        }
        else {
            $j(div_selector).hide();
        }
    });
}

function init_events(){
    toggle_display();
    $j("#iframe_div_premode").toggle(false);
    $j("#embed_personnalisation").toggle(false);
    $j("#player_width").val(550);
    $j("#player_height").val(300);
    $j("#optionsExpArrow").toggle(true);
    $j("#optionsCollArrow").toggle(false);	
    $j("#preModeExpArrow").toggle(true);
    $j("#preModeCollArrow").toggle(false);
    $j("#createannotation_block").toggle(true);
    $j("#player_id_code").select();
    $j("#polemic_color_options").toggle(false);
    $j("#sparkline_color_options").toggle(false);
    $j("#social_options").toggle(false);
    $j("#displaySegmentsOptions").toggle(false);
    $j("#displayPolemicOptions").toggle(false);
    $j("#displaySparklineOptions").toggle(false);
    $j("#polemic_default_color").val("#585858");
    $j("#polemic_found_color").val("#fc00ff");
    $j("#polemic_ok_color").val("#1d973d");
    $j("#polemic_ko_color").val("#ce0a15");
    $j("#polemic_ref_color").val("#c5a62d");
    $j("#polemic_q_color").val("#036aae");
    $j("#sparkline_line_color").val("#7492b4");
    $j("#sparkline_fill_color").val("#aeaeb8");
    var type_embed=document.getElementById("type_embed_div");
    type_embed.checked=true;
    $j("#createannotation_options").toggle(false);
    mode1();

    $j(".click_to_select").click(function(){
        var i = $j(this).parent().find("input");
        i.select();
    });

    $j('.ldt_json_link').click(function(e) {
        e.preventDefault();
        link = $j(e.target);
        $j("#res_link_{{player_id}}").load(link.attr("href"));
        $j("#res_link_{{player_id}}").show();
        return false;
    });

    $j('#player_button').click(function(e) {
        display_state = "player";
        toggle_display();
        $j("#player_id_code").select();
    });
    $j('#ldt_iframe_button').click(function(e) {
        display_state = "ldt_iframe";
        toggle_display();
        $j("#ldt_iframe_id_code").select();
    });
    $j('#seo_body_button').click(function(e) {
        display_state = "seo_body";
        toggle_display();
        $j("#seo_body_id_code").select();
    });
    $j('#seo_meta_button').click(function(e) {
        display_state = "seo_meta";
        toggle_display();
        $j("#seo_meta_id_code").select();
    });
    $j('#links_button').click(function(e) {
        display_state = "links";
        toggle_display();
    });

    $j("#copy_button").click(function(e) {
        alert($j("#"+display_state+"_code").html());
    });

    $j("#refresh_player_button").click(function(e){
        refresh_player();
        $j("#player_id_code").select();
    });


    $j('#links_button').click(function() {
        var range = document.createRange();
        range.selectNode(document.getElementById('links_code'));
        window.getSelection().addRange(range);
    });

    $j('#displayPreMode').click(function(){
        $j("#iframe_div_premode").slideToggle("fast");
        $j("#preModeExpArrow").toggle();
        $j("#preModeCollArrow").toggle();
    });

    $j("#displayEmbedOptions").click(function(){
        $j("#embed_personnalisation").slideToggle("fast");
        $j("#optionsExpArrow").toggle();
        $j("#optionsCollArrow").toggle();

    });

    $j("#displayPolemicColorOptions").click(function(){
        $j("#polemic_color_options").slideToggle("fast");
    });

    $j("#displaySparklineOptions").click(function(){
        $j("#sparkline_color_options").slideToggle("fast");
    });

    $('.infostooltip').each( function () {
        var desc = $(this).attr('data-desc');
        if (desc == 'None') {
            desc = '';
        }
        $(this).qtip({ 
            content : {
                text: '<b>' + $(this).attr('data-title') + '</b><br />' + desc
            },
            style: {
                classes: 'ui-tooltip-dark ui-tooltip-rounded qtipldt'
            },
            border: {
                'width': 0,
                'color': '#505050'
            },
            position: {
                my: 'top left',
                at: 'bottom left'
            }
        });
    });

}

function generate_base_embed_code(){
    var concatenate_projects_val = document.getElementById("concatenate_projects_checkbox");
    var player_width_val=$j("#player_width").val();
    var json_url_embed;
    if (concatenate_projects_val.checked){
        json_url_embed=json_url_concatenate;
    }
    else {
        json_url_embed=json_url;
    }
    return '\
        <div> \n \
        <div id="'+player_id+'_embed" style="float:left; width:'+player_width_val+';" class="iri_player_embed">\n\
        </div>\n\
        <script type="text/javascript" src="'+LdtPlayer_core+'"></script>\n\
        <script type="text/javascript">\n\
        if (typeof jQuery == "undefined") {\n\
        jQuery = IriSP.jQuery;\n\
        }\n\
        var metadatas = {metadata: {url: "'+json_url_embed+'"}};\n\
        var metadata_key = "metadata";\n\
        IriSP.libFiles.defaultDir = "'+defaultDir+'";\n\
        IriSP.libFiles.locations.jwPlayerSWF = "'+jwPlayerSWF+'";\n\
        IriSP.libFiles.locations.recordMicSwf = "'+recordMicSwf+'";\n\
        IriSP.libFiles.locations.zeroClipboardSwf = "'+zeroClipboardSwf+'";\n\
        IriSP.libFiles.locations.cssjQueryUI = "'+cssjQueryUI+'";\n\
        IriSP.language = "'+LANGUAGE_CODE+'";\n\
        \n\
        IriSP.widgetsDir = "'+widgetsDir+'";\n\
        var _metadata = {\n\
        url: metadatas[metadata_key].url,\n\
        format: "ldt"\n\
        };\n\
        var _config = {\n\
        width: "'+player_width_val+'",\n\
        container: "'+player_id+'_embed",\n\
        css: "'+configCss+'",\n\
        default_options: {\n\
        metadata: _metadata\n\
        },\n';

}

function generate_widget_code(){
    var annotationslist_val=document.getElementById('annotations_list_checkbox');
    var slideshare_val=document.getElementById('slideshare_checkbox');
    var social_val=document.getElementById('social_checkbox');
    var annotation_val=document.getElementById('annotation_checkbox');
    var tweet_val=document.getElementById('tweet_checkbox');
    var segments_val=document.getElementById('segments_checkbox');
    var multisegments_val=document.getElementById('multisegments_checkbox');
    var polemic_val=document.getElementById('polemic_checkbox');
    var sparkline_val=document.getElementById('sparkline_checkbox');
    var tagcloud_val=document.getElementById('tagcloud_checkbox');
    var player_height_val=$j('#player_height').val();
    var autostart_val=document.getElementById('autostart_checkbox');
    var createannotation_val=document.getElementById('createannotation_checkbox');
    var widget_code=
        '  widgets: [\n' +
        '  {\n' +
        '    type: "AutoPlayer",\n' +
        '    streamer: function(_url) {\n' +
        '      var _matches = _url.match(/^[^\\/]+\\/\\/[^\\/]+\\/[^\\/]+\\//);\n' +
        '      if (_matches) {\n' +
        '        return _matches[0];\n' +
        '      } else {\n' +
        '        return _url;\n' +
        '      }\n' +
        '    },\n' +
        '    url_transform: function(url) {\n' +
        '      // Adaptation to jwplayer 6\n' +
        '      if (url.substr(url.length - 4).toLowerCase()===\'.flv\'){\n' +
        '        return url.replace(\'/ddc_player/video/\',\'/ddc_player/flv:video/\');\n' +
        '      }\n' +
        '      return url.replace(\'/ddc_player/video/\',\'/ddc_player/mp4:video/\');\n' +
        '    },\n';

    if (external_url!='None'){
        widget_code+='video: "'+external_url+'",\n';
    }

    widget_code+='height: '+player_height_val+',\n'  

    if (autostart_val.checked){
        widget_code+='autostart: true\n\}';
    }
    else {
        widget_code+='autostart: false\n\}';
    }
    
    widget_code += ',{\n' +
        'type: "Slider"\n' +
        '},{\n' +
        'type: "Controller"\n' +
        '},{\n' +
        'type: "Mediafragment"\n' +
        '}\n';
    
    if (polemic_val.checked){	
        var defaultcolor= $j("#polemic_default_color").val(),
            foundcolor=$j("#polemic_found_color").val(),
            ok_color=$j("#polemic_ok_color").val(),
            ko_color=$j("#polemic_ko_color").val(),
            ref_color=$j("#polemic_ref_color").val(),
            q_color=$j("#polemic_q_color").val(),
            polemic_annotation_types_val=document.getElementById("polemic_annotation_types");
        widget_code+='\
            ,{\n\
            type: "Polemic",\n';
        if(polemic_annotation_types_val.value){
            var polemic_annotation_types_array=polemic_annotation_types_val.value.split(",")
            widget_code+='\
                annotation_type: [';
            for (i=0; i<polemic_annotation_types_array.length; i++){
                widget_code+='"'+polemic_annotation_types_array[i]+'"'
                if (i!=polemic_annotation_types_array.length-1){
                    widget_code+=','
                }
            }
            widget_code+='],\n';
        }
        else{
            widget_code+='\
                annotation_type: false,\n';
        }
        widget_code+='\
            defaultcolor: "'+defaultcolor+'",\n\
            foundcolor: "'+foundcolor+'",\n\
            polemics : [\n\
            {\n\
            "name" : "OK",\n\
            "keywords" : [ "++" ],\n\
            "color" : "'+ok_color+'"\n\
            },\n\
            {\n\
            "name" : "KO",\n\
            "keywords" : [ "--" ],\n\
            "color" : "'+ko_color+'"\n\
            },\n\
            {\n\
            "name" : "REF",\n\
            "keywords" : [ "==" ],\n\
            "color" : "'+ref_color+'"\n\
            },\n\
            {\n\
            "name" : "Q",\n\
            "keywords" : [ "?" ],\n\
            "color" : "'+q_color+'"\n\
            },\n\
            ]\n\
            }';
    }

    if(sparkline_val.checked){
        var linecolor=$j("#sparkline_line_color").val(),
            fillcolor=$j("#sparkline_fill_color").val();
        widget_code+=',{\n\
            type: "Sparkline",\n\
            lineColor: "'+linecolor+'",\n\
            fillColor: "'+fillcolor+'"\n\
            }';
    }

    if(segments_val.checked){
        widget_code+=',{\n\
            type: "Segments",\n';
        var segments_annotation_types_val=document.getElementById('segments_annotation_types');

        if(segments_annotation_types_val.value){
            var segments_annotation_types_array=segments_annotation_types_val.value.split(",")
            widget_code+='\
                annotation_type: [';
            for (var i=0; i<segments_annotation_types_array.length; i++){
                widget_code+='"'+segments_annotation_types_array[i]+'"'
                if (i!=segments_annotation_types_array.length-1){
                    widget_code+=','
                }
            }
            widget_code+='],\n';
        }
        else {
            widget_code+='annotation_type: false\n';
        }
        widget_code+='}';
    }
    if(multisegments_val.checked){
        widget_code+=',{\n\
            type: "MultiSegments",\n\
            }';
    }

    if(createannotation_val.checked) {
        
        var tag_titles = ($j('input[name=annotation_tag]:checked').attr('id') === 'set_tags') ? $j('#tag_list').val() : false;
        var show_mic_record = $j("#show_mic_record_checkbox").prop('checked');
        var createannotation_polemics = $j('#createannotation_polemics_checkbox').prop('checked');
        var createannotation_annotation_types = $j('#createannotation_annotation_types').val();
        
        widget_code +=
        ',\n{\n' +
        '  type: "CreateAnnotation",\n' +
        '  api_endpoint_template: "'+ annotation_api +'",\n' +
        '  after_send_timeout: 8000,\n' +
        '  tag_titles : ' + ( (tag_titles || tag_titles === "") ? JSON.stringify(tag_titles.split(',')) : 'false') + ',\n' + 
        '  show_mic_record : ' +  (show_mic_record ? 'true' : 'false') + ',\n' +
        '  close_after_send: false,\n' +
        '  slice_annotation_type: ' + (createannotation_annotation_types ? JSON.stringify(createannotation_annotation_types.split(',')) : '["chap","découpage"]') + ',\n' +
        '  creator_avatar: "https://si0.twimg.com/sticky/default_profile_images/default_profile_1_normal.png",\n' +
        ((!createannotation_polemics) ? '  polemics: []' : '') + '\n'
        + '}\n';
    }

    if(slideshare_val.checked){
        widget_code+='\
            ,{\n\
            type: "Slideshare",\n\
            container: "Slideshare_ext",\n\
            embed_width: 400,\n\
            embed_height: 334,\n\
            annotation_type: "slide"\n\
            }';
    }

    if(social_val.checked){
        var show_url=document.getElementById("show_url_checkbox"),
            show_twitter=document.getElementById("show_twitter_checkbox"),
            show_fb=document.getElementById("show_fb_checkbox"),
            show_gplus=document.getElementById("show_gplus_checkbox"),
            show_mail=document.getElementById("show_mail_checkbox");

        widget_code+='\
            ,{\n\
            type: "Social",\n\
            container: "Social_ext",\n\
            url: document.location.href.replace(/#.*$/,""),\n\
            text: document.title,\n';

        if(show_url.checked){
            widget_code+='\
                show_url: true,\n';
        }
        else{
            widget_code+='\
                show_url: false,\n';
        }
        if(show_twitter.checked){
            widget_code+='\
                show_twitter: true,\n';
        }
        else{
            widget_code+='\
                show_twitter: false,\n';
        }
        if(show_fb.checked){
            widget_code+='\
                show_fb: true,\n';
        }
        else{
            widget_code+='\
                show_fb: false,\n';
        }
        if(show_gplus.checked){
            widget_code+='\
                show_gplus: true,\n';
        }
        else{
            widget_code+='\
                show_gplus: false,\n';
        }
        if(show_mail.checked){
            widget_code+='\
                show_mail: true\n';
        }
        else{
            widget_code+='\
                show_mail: false\n';
        }

        widget_code+='}';
    }
    if(annotation_val.checked){
        widget_code+='\
            ,{\n\
            type: "Annotation",\n\
            start_minimized: true,\n\
            site_name : "Lignes de Temps",\n\
            annotation_type: ["chap","découpage"]\n\
            }';
    }
    if(tweet_val.checked){
        widget_code+='\
            ,{\n\
            type: "Tweet",\n\
            hide_timeout: 5000\n\
            }';
    }

    if(annotationslist_val.checked){
        widget_code+=',{\n\
            type: "AnnotationsList",\n\
            ajax_url: "'+segment_api+'",\n\
            container: "AnnotationsList_ext",\n\
            ajax_granularity : 300000,\n\
            default_thumbnail : "'+default_thumbnail+'",\n\
            show_audio: true,\n\
            rtmp_streamer: "rtmp://media.iri.centrepompidou.fr/ddc_micro_record/"\n\
            }';
    }

    if(tagcloud_val.checked){
        widget_code+=',{\n\
            type: "Tagcloud",\n\
            }';
    }

    widget_code+=']\n\
        };\n';

    return widget_code;

}

function generate_div_code(){
    var annotationslist_val=document.getElementById('annotations_list_checkbox');
    var slideshare_val=document.getElementById('slideshare_checkbox');
    var social_val=document.getElementById('social_checkbox');
    var code = generate_base_embed_code();
    code += generate_widget_code();
    code += '\n\
        _myPlayer = new IriSP.Metadataplayer(_config);\n\
        </script>\n';
    if(social_val.checked){
        code+='\
            <div id="Social_ext" class="Ldt-TraceMe Ldt-Widget" style="float:right; width:400px; height:24px;" widget-type="Social">\n\
            </div>\n';
    }
    if(slideshare_val.checked){
        code+='\
            <div id="Slideshare_ext" class="ext_widget Ldt-TraceMe Ldt-Widget" style="float:left; width:400px;" widget-type="Slideshare">\n\
            </div>\n';
    }

    if(annotationslist_val.checked){
        code+='\
            <div id="AnnotationsList_ext" class="ext_widget Ldt-TraceMe Ldt-Widget" style="float:left; width:400px;" widget-type="AnnotationsList"></div>\n';
    }

    code+='\
        </div>\n';
    return code;	
}

function put_new_code(){
    var type_embed=document.getElementById("type_embed_div");
    var wrapper = "wrapper_"+player_id;
    var wrapper_id = "#"+wrapper;
    var element = document.getElementById(wrapper);
    var code_embed=document.getElementById("player_id_code");
    if(type_embed.checked){
        var new_code=generate_div_code();
    }
    else{
        var new_code=generate_iframe_code();
    }
    code_embed.value= new_code;
    $j("#player_id_code").select();	
}

function div_event(){
    //$j("#createannotation_block").toggle(true);
    var wrapper="wrapper_"+player_id;
    var element = document.getElementById(wrapper);
    var createannotation_val=document.getElementById('createannotation_checkbox');
    createannotation_val.checked=false;
    $j("#createannotation_options").toggle(false);
    $j("#multisegments_block").toggle(true);
    put_new_code();
}

function toggle() {
    var wrapper="wrapper_"+player_id;
    var wrapper_id="#"+wrapper;
    var player_div = document.getElementById("player_div");
    var element = document.getElementById(wrapper);
    var text = document.getElementById("displayPlayer");
    var type_embed=document.getElementById("type_embed_div");
    var refresh_player_button = $j('#refresh_player_button');
    if(player_div.style.display==="none") {
        if (type_embed.checked){
            var new_code=generate_div_code();
            $j(wrapper_id).html(new_code);
        }
        else{
            display_iframe_player();
        }
        player_div.style.display="block";
        refresh_player_button.show();
        text.innerHTML = translate_hide;
    }
    else {
        $j(wrapper_id).html('');
        player_div.style.display="none";
        refresh_player_button.hide();
        text.innerHTML = translate_show;
    }
} 

function display_polemic(){
    $j("#displayPolemicOptions").slideToggle("fast");
    $j("#polemic_color_options").toggle(false);
}

function display_segments(){
    $j("#displaySegmentsOptions").slideToggle("fast");
}

function display_sparkline(){
    $j("#displaySparklineOptions").slideToggle("fast");		
    $j("#sparkline_color_options").toggle(false);
}

function display_social(){
    $j("#social_options").slideToggle("fast");
}

function display_createannotation(){
    $j("#createannotation_options").slideToggle("fast");
}

function mode1(){
    var annotationslist_val=document.getElementById('annotations_list_checkbox');
    var slideshare_val=document.getElementById('slideshare_checkbox');
    var social_val=document.getElementById('social_checkbox');
    var annotation_val=document.getElementById('annotation_checkbox');
    var tweet_val=document.getElementById('tweet_checkbox');
    var segments_val=document.getElementById('segments_checkbox');
    var multisegments_val=document.getElementById('multisegments_checkbox');
    var polemic_val=document.getElementById('polemic_checkbox');
    var sparkline_val=document.getElementById('sparkline_checkbox');
    var tagcloud_val=document.getElementById('tagcloud_checkbox');
    var createannotation_val=document.getElementById('createannotation_checkbox');

    var type_embed=document.getElementById("type_embed_div");

    if(type_embed.checked){
        createannotation_val.checked=false;
    }
    else{
        $j("#createannotation_options").toggle(true);
        createannotation_val.checked=true;
        var show_mic_record_val = document.getElementById('show_mic_record_checkbox');
        show_mic_record_val.checked=false;
    }
    $j("#displaySegmentsOptions").toggle(false);
    $j("#displayPolemicOptions").toggle(false);
    $j("#displaySparklineOptions").toggle(false);
    $j("#social_options").toggle(false);
    $j("#sparkline_color_options").toggle(false);
    display_segments();

    segments_val.checked=true;
    multisegments_val.checked=false;
    polemic_val.checked=false;
    annotationslist_val.checked=false;
    slideshare_val.checked=false;
    social_val.checked=false;
    annotation_val.checked=false;
    tweet_val.checked=false;
    sparkline_val.checked=false;
    tagcloud_val.checked=false;
    put_new_code();
}

function mode2(){
    var annotationslist_val=document.getElementById('annotations_list_checkbox');
    var slideshare_val=document.getElementById('slideshare_checkbox');
    var social_val=document.getElementById('social_checkbox');
    var annotation_val=document.getElementById('annotation_checkbox');
    var tweet_val=document.getElementById('tweet_checkbox');
    var segments_val=document.getElementById('segments_checkbox');
    var multisegments_val=document.getElementById('multisegments_checkbox');
    var polemic_val=document.getElementById('polemic_checkbox');
    var sparkline_val=document.getElementById('sparkline_checkbox');
    var tagcloud_val=document.getElementById('tagcloud_checkbox');
    var createannotation_val=document.getElementById('createannotation_checkbox');
    var type_embed=document.getElementById("type_embed_div");	
    $j("#displaySegmentsOptions").toggle(false);
    $j("#displayPolemicOptions").toggle(false);
    $j("#displaySparklineOptions").toggle(false);
    $j("#social_options").toggle(false);
    $j("#sparkline_color_options").toggle(false);
    display_segments();
    display_polemic();
    display_sparkline();

    if(type_embed.checked){
        createannotation_val.checked=false;
        multisegments_val.checked=false;
    }
    else{
        $j("#createannotation_options").toggle(true);
        createannotation_val.checked=true;
        var show_mic_record_val = document.getElementById('show_mic_record_checkbox');
        show_mic_record_val.checked=false;

    }
    polemic_val.checked=true;
    segments_val.checked=true;
    multisegments_val.checked=false;
    annotationslist_val.checked=false;
    slideshare_val.checked=false;
    social_val.checked=false;
    annotation_val.checked=true;
    sparkline_val.checked=true;
    tweet_val.checked=false;
    tagcloud_val.checked=false;
    put_new_code();

}

function mode3(){
    var annotationslist_val=document.getElementById('annotations_list_checkbox');
    var slideshare_val=document.getElementById('slideshare_checkbox');
    var social_val=document.getElementById('social_checkbox');
    var annotation_val=document.getElementById('annotation_checkbox');
    var tweet_val=document.getElementById('tweet_checkbox');
    var segments_val=document.getElementById('segments_checkbox');
    var multisegments_val=document.getElementById('multisegments_checkbox');
    var polemic_val=document.getElementById('polemic_checkbox');
    var sparkline_val=document.getElementById('sparkline_checkbox');
    var tagcloud_val=document.getElementById('tagcloud_checkbox');
    var createannotation_val=document.getElementById('createannotation_checkbox');
    var type_embed=document.getElementById("type_embed_div");
    $j("#displaySegmentsOptions").toggle(false);
    $j("#displayPolemicOptions").toggle(false);
    $j("#displaySparklineOptions").toggle(false);
    $j("#social_options").toggle(false);
    $j("#sparkline_color_options").toggle(false);
    display_segments();
    display_polemic();
    display_social();
    display_sparkline();
    if(type_embed.checked){
        createannotation_val.checked=false;
    }
    else{
        $j("#createannotation_options").toggle(true);
        createannotation_val.checked=true;
        var show_mic_record_val = document.getElementById('show_mic_record_checkbox');
        show_mic_record_val.checked=false;	
    }
    polemic_val.checked=true;
    segments_val.checked=true;
    multisegments_val.checked=false;
    annotationslist_val.checked=true;
    slideshare_val.checked=false;
    social_val.checked=true;
    annotation_val.checked=true;
    tweet_val.checked=false;
    sparkline_val.checked=true;
    tagcloud_val.checked=true;
    put_new_code();

}
function iframe_event() {
    var wrapper="wrapper_"+player_id;
    $j("#createannotation_options").toggle(true);
    var element = document.getElementById(wrapper);
    var createannotation_val=document.getElementById('createannotation_checkbox');
    createannotation_val.checked=true;
    if(element.style.display=="block"){
        display_iframe_player();
    }
    var iframe_code=generate_iframe_code();
    $j("#player_id_code").val(iframe_code);
    $j("#player_id_code").select();

}	

function generate_iframeUrl(){
    var createannotation_val=document.getElementById('createannotation_checkbox');
    var annotationslist_val=document.getElementById('annotations_list_checkbox');
    var slideshare_val=document.getElementById('slideshare_checkbox');
    var social_val=document.getElementById('social_checkbox');
    var annotation_val=document.getElementById('annotation_checkbox');
    var tweet_val=document.getElementById('tweet_checkbox');
    var segments_val=document.getElementById('segments_checkbox');
    var multisegments_val=document.getElementById('multisegments_checkbox');
    var polemic_val=document.getElementById('polemic_checkbox');
    var sparkline_val=document.getElementById('sparkline_checkbox');
    var tagcloud_val=document.getElementById('tagcloud_checkbox');
    var createannotation_polemics_val=document.getElementById('createannotation_polemics_checkbox');
    var concatenate_projects_val=document.getElementById('concatenate_projects_checkbox');
    var autostart_val=document.getElementById('autostart_checkbox');
    var iframeUrl=iframe_url;

    if($j("#player_height").val()!=300)
        iframeUrl+="&player_height="+$j("#player_height").val();
    if ($j("#player_width").val()!=550)
        iframeUrl+="&player_width="+$j("#player_width").val();

    if(createannotation_val.checked){
        iframeUrl+="&createannotation=True";
        var show_mic_record_val = document.getElementById('show_mic_record_checkbox');
        var set_tags_val=document.getElementById('set_tags');
        var createannotation_annotation_types = $j('#createannotation_annotation_types').val(); 
        if(show_mic_record_val.checked){
            iframeUrl+="&show_mic_record=True";
        }
        if(set_tags_val.checked){
            iframeUrl+="&tag_titles="+$j("#tag_list").val();
        }
        if(!createannotation_polemics_val.checked){
            iframeUrl+="&createannotation_polemics=False";
        }
        if(createannotation_annotation_types) {
            iframeUrl += "&createannotation_annotation_types="+createannotation_annotation_types;
        }
    }
    if (polemic_val.checked){
        var polemic_annotation_types_val=document.getElementById("polemic_annotation_types");
        if(polemic_annotation_types_val.value){
            iframeUrl+="&polemic="+polemic_annotation_types_val.value;
        }
        else{
            iframeUrl+="&polemic=all";
        }
        var polemic_defaultColor=$j("#polemic_default_color").val(),
            defaultColor_code_array= polemic_defaultColor.split("#"),
            defaultColor_code=defaultColor_code_array[1],
            polemic_foundColor=$j("#polemic_found_color").val(),
            foundColor_code_array = polemic_foundColor.split("#"),
            foundColor_code=foundColor_code_array[1],
            polemic_okColor =$j("#polemic_ok_color").val(),
            polemic_okColor_code_array=polemic_okColor.split("#"),
            okColor_code=polemic_okColor_code_array[1],
            polemic_koColor =$j("#polemic_ko_color").val(),
            polemic_koColor_code_array=polemic_koColor.split("#"),
            koColor_code=polemic_koColor_code_array[1],
            polemic_refColor =$j("#polemic_ref_color").val(),
            polemic_refColor_code_array=polemic_refColor.split("#"),
            refColor_code=polemic_refColor_code_array[1],
            polemic_qColor =$j("#polemic_q_color").val(),
            polemic_qColor_code_array=polemic_qColor.split("#"),
            qColor_code=polemic_qColor_code_array[1];
        if(defaultColor_code!="585858")
            iframeUrl+="&polemic_defaultColor="+defaultColor_code;
        if(foundColor_code!="fc00ff")
            iframeUrl+="&polemic_foundColor="+foundColor_code;
        if(okColor_code!="1d973d")
            iframeUrl+="&polemic_okColor="+okColor_code;
        if(koColor_code!="ce0a15")
            iframeUrl+="&polemic_koColor="+koColor_code;
        if(refColor_code!="c5a62d")
            iframeUrl+="&polemic_refColor="+refColor_code;
        if(qColor_code!="036aae")
            iframeUrl+="&polemic_qColor="+qColor_code;

    }
    if(annotationslist_val.checked){
        iframeUrl+="&annotations_list=True";
    }
    if(annotation_val.checked){
        iframeUrl+="&annotation=True";
    }
    if(slideshare_val.checked){
        iframeUrl+="&slideshare=True";
    }
    if(social_val.checked){
        var show_url=document.getElementById("show_url_checkbox"),
            show_twitter=document.getElementById("show_twitter_checkbox"),
            show_fb=document.getElementById("show_fb_checkbox"),
            show_gplus=document.getElementById("show_gplus_checkbox"),
            show_mail=document.getElementById("show_mail_checkbox");
        iframeUrl+="&social=True";
        if(!show_url.checked){
            iframeUrl+="&show_url=False";
        }
        if(!show_twitter.checked){
            iframeUrl+="&show_twitter=False";
        }
        if(!show_fb.checked){
            iframeUrl+="&show_fb=False";
        }
        if(!show_gplus.checked){
            iframeUrl+="&show_gplus=False";
        }
        if(!show_mail.checked){
            iframeUrl+="&show_mail=False";
        }
    }
    if(tweet_val.checked){
        iframeUrl+="&tweet=True";
    }
    if(!segments_val.checked){
        iframeUrl+="&segments=False";
    }
    else{
        var segments_annotation_types_val=document.getElementById("segments_annotation_types");
        if (segments_annotation_types_val.value){
            iframeUrl+="&segments_annotation_types="+segments_annotation_types_val.value
        }
    }
    if(multisegments_val.checked){
        iframeUrl+="&multisegments=True"
    }
    if(sparkline_val.checked){
        iframeUrl+="&sparkline=True";
        var sparkline_lineColor=$j("#sparkline_line_color").val(),
            lineColor_code_array= sparkline_lineColor.split("#"),
            lineColor_code=lineColor_code_array[1],
            sparkline_fillColor=$j("#sparkline_fill_color").val(),
            fillColor_code_array = sparkline_fillColor.split("#"),
            fillColor_code=fillColor_code_array[1];
        if(lineColor_code!="7492b4")
            iframeUrl+="&sparkline_lineColor="+lineColor_code;
        if(fillColor_code!="aeaeb8")
            iframeUrl+="&sparkline_fillColor="+fillColor_code;
    }
    if(tagcloud_val.checked){
        iframeUrl+="&tagcloud=True";
    }
    if(concatenate_projects_val.checked){
        iframeUrl+="&concatenate_projects=True";
    }
    if(autostart_val.checked){
        iframeUrl+="&autostart=True";
    }

    return iframeUrl;
}

function generate_iframe_code(){
    var createannotation_val=document.getElementById('createannotation_checkbox');
    var annotationslist_val=document.getElementById('annotations_list_checkbox');
    var polemic_val=document.getElementById('polemic_checkbox');
    var slideshare_val=document.getElementById('slideshare_checkbox');
    var show_mic_record_val = document.getElementById('show_mic_record_checkbox');
    var iframeUrl=generate_iframeUrl();
    var player_width=parseInt($j("#player_width").val())+20;
    var player_height=parseInt($j("#player_height").val())+130;
    if (createannotation_val.checked){
        player_height+=281;
    }
    if(annotationslist_val.checked || slideshare_val.checked){
        player_width+=430;
    }
    if(polemic_val.checked){
        player_height+=100;

    }
    if(show_mic_record_val.checked){

        player_height+=55;
    }


    return "<iframe src='"+iframeUrl+"' width='"+player_width+"' height='"+player_height+"' seamless='seamless'></iframe>";
}

function display_iframe_player(){
    var createannotation_val=document.getElementById('createannotation_checkbox');
    var annotationslist_val=document.getElementById('annotations_list_checkbox');
    var polemic_val=document.getElementById('polemic_checkbox');
    var slideshare_val=document.getElementById('slideshare_checkbox');
    var show_mic_record_val = document.getElementById('show_mic_record_checkbox');
    var code_embed=document.getElementById("player_id_code");
    var wrapper = "wrapper_"+player_id;
    var wrapper_id = "#"+wrapper;
    var iframeUrl= generate_iframeUrl();
    var player_width=parseInt($j("#player_width").val())+20;
    var player_height=parseInt($j("#player_height").val())+130;
    if (createannotation_val.checked){
        player_height+=300;
        player_width+=50;
    }
    if(annotationslist_val.checked || slideshare_val.checked){
        player_width+=430;
    }
    if(polemic_val.checked){
        player_height+=100;

    }
    if(show_mic_record_val.checked){

        player_height+=55;
    }
    var frame = document.createElement("iframe");
    frame.width = player_width;
    frame.height = player_height;
    frame.src = iframeUrl;
    frame.frameBorder = 0;
    frame.seamless = "seamless";
    $j(wrapper_id).html(frame);
}

function set_default_color(code){
    $j("#polemic_default_color").val("#"+code);
    put_new_code();
}

function set_found_color(code){
    $j("#polemic_found_color").val("#"+code);
    put_new_code();
}

function set_line_color(code){
    $j("#sparkline_line_color").val("#"+code);
    put_new_code();
}

function set_fill_color(code){
    $j("#sparkline_fill_color").val("#"+code);
    put_new_code();
}

function refresh_player(){
    var wrapper = "wrapper_"+player_id;
    var wrapper_id = "#"+wrapper;
    var type_embed=document.getElementById("type_embed_div");
    if (type_embed.checked){
        var new_code=generate_div_code();
        $j(wrapper_id).html(new_code);
    }
    else{
        display_iframe_player();
    }
}
