#@PydevCodeAnalysisIgnore
import os.path
# Django settings for project.

DEBUG = True
TEMPLATE_DEBUG = DEBUG

ADMINS = (
    # ('Your Name', 'your_email@domain.com'),
)

MANAGERS = ADMINS

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends', # Add 'postgresql_psycopg2', 'postgresql', 'mysql', 'sqlite3' or 'oracle'.
        'NAME': '',                      # Or path to database file if using sqlite3.
        'USER': '',                      # Not used with sqlite3.
        'PASSWORD': '',                  # Not used with sqlite3.
        'HOST': '',                      # Set to empty string for localhost. Not used with sqlite3.
        'PORT': '',                      # Set to empty string for default. Not used with sqlite3.
    }
}

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'Europe/Paris'

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'fr-fr'

ugettext = lambda s: s

LANGUAGES = ( 
    ('fr', ugettext('French')),
)


SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = ''

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash if there is a path component (optional in other cases).
# Examples: "http://media.lawrence.com", "http://example.com/media/"
MEDIA_URL = ''

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
ADMIN_MEDIA_PREFIX = '/media/'

LDT_MEDIA_PREFIX = '/ldt/'

# Make this unique, and don't share it with anybody.
SECRET_KEY = 't^lii5_z@tho$%6t&b#dm#t9nz$$ylyclxvkdiyqbl+(dnt(ma'

# List of callables that know how to import templates from various sources.
TEMPLATE_LOADERS = (
    'django.template.loaders.filesystem.Loader',
    'django.template.loaders.app_directories.Loader',
#     'django.template.loaders.eggs.Loader',
)

MIDDLEWARE_CLASSES = (
    'django.middleware.gzip.GZipMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.middleware.locale.LocaleMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'jogging.middleware.LoggingMiddleware',
)

TEMPLATE_CONTEXT_PROCESSORS = ( 
    "django.core.context_processors.request",
    "django.core.context_processors.auth",
    "django.core.context_processors.debug",
    "django.core.context_processors.i18n",
    "django.core.context_processors.media",
    "ldt.utils.context_processors.ldt",
    "ldt.utils.context_processors.base",
    "ldt.utils.context_processors.web",
    "ldtplatform.utils.context_processors.version",
)


ROOT_URLCONF = 'ldtplatform.urls'

TEMPLATE_DIRS = (
    # Put strings here, like "/home/html/django_templates" or "C:/www/django/templates".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
    os.path.join(os.path.basename(__file__), 'templates'),
)

FIXTURES_DIRS = (
    os.path.join(os.path.basename(__file__), 'fixtures'),
)

INSTALLED_APPS = (
    'jogging',
    'django_extensions',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.messages',
    'django.contrib.admin',
    'ldtplatform',
    'registration',
    'tagging',
    'ldt',
    'ldt.core',
    'ldt.ldt_utils',
    'ldt.text',
    'ldt.user',
    'ldt.management',
    'oauth_provider',
)

DECOUPAGE_BLACKLIST = (
     "de_PPP",
)
 
ZIP_BLACKLIST = (
     "__MACOSX",
)

ACCOUNT_ACTIVATION_DAYS = 7 

LDT_MAX_SEARCH_NUMBER = 50
LDT_JSON_DEFAULT_INDENT = 0

OAUTH_PROVIDER_KEY_SIZE = 32
OAUTH_PROVIDER_SECRET_SIZE = 32
OAUTH_PROVIDER_VERIFIER_SIZE = 10
OAUTH_PROVIDER_CONSUMER_KEY_SIZE = 256
OAUTH_AUTHORIZE_VIEW = 'oauth_provider.views.fake_authorize_view'
OAUTH_CALLBACK_VIEW = 'oauth_provider.views.fake_callback_view'
TEST_WEBSERVER_ADDRPORT = "127.0.0.1:8888"

from config import *

LOGIN_URL = BASE_URL + 'ldtplatform/accounts/login/'
LOGOUT_URL = BASE_URL + 'ldtplatform/accounts/logout/'
LOGIN_REDIRECT_URL = BASE_URL + 'ldtplatform'

GLOBAL_LOG_LEVEL = LOG_LEVEL
GLOBAL_LOG_HANDLERS = [{'handler':logging.FileHandler(LOG_FILE), 'format':"%(asctime)s - %(levelname)s : %(message)s"}]

