# -*- coding: utf-8 -*-
'''
Created on Feb 1, 2012

@author: ymh
'''
import sys
import codecs #@UnresolvedImport
import math

def show_progress(current_line, total_line, label, width, writer=None):

    if writer is None:
        writer = sys.stdout
        if sys.stdout.encoding is not None:
            writer = codecs.getwriter(sys.stdout.encoding)(sys.stdout)

    percent = (float(current_line) / float(total_line)) * 100.0

    marks = math.floor(width * (percent / 100.0)) #@UndefinedVariable
    spaces = math.floor(width - marks) #@UndefinedVariable

    loader = u'[' + (u'=' * int(marks)) + (u' ' * int(spaces)) + u']'
        
    s = u"%s %3d%% %*d/%d - %*s\r" % (loader, percent, len(str(total_line)), current_line, total_line, width, label[:width])
    
    writer.write(s) #takes the header into account
    if percent >= 100:
        writer.write("\n")
    writer.flush()
    
    return writer
