from ldt.ldt_utils.models import Project
from piston.handler import BaseHandler
from piston.utils import rc, require_extended
import logging #@UnresolvedImport

class ProjectHandler(BaseHandler):
    allowed_methods = ('GET','PUT',)
    model = Project   

    def read(self, request, project_id):
        """
        returns a single project
        """
        return Project.objects.get(ldt_id=project_id)
    
    @require_extended
    def update(self, request, project_id):
        """
        update a project.
        """
        logging.debug("request " + repr(request))
        data = request.data
        ldt_str = data["ldt"] 
        
        logging.debug("request data" + repr(ldt_str))
        
        if not ldt_str:
            return rc.ALL_OK
        
        project = Project.objects.get(ldt_id=project_id)
        
        project.ldt = ldt_str
        
        project.save()
        
        return rc.ALL_OK
