# -*- coding: utf-8 -*-
'''
Created on Jul 21, 2015

@author: ymh
'''
import logging

from tastypie.test import ResourceTestCase, TestApiClient
from ldt.api.ldt.serializers.cinelabserializer import CinelabSerializer
from django.core.urlresolvers import reverse
from ldt.ldt_utils.models import Project
import json


logger = logging.getLogger(__name__)

class ProjectTest(ResourceTestCase):

    fixtures = ['tests/api/projects_user.json', 'tests/api/projects_project.json']

    def get_credentials(self):
        result = self.api_client.client.login(username='admin',password='admin')
        return result
    
    
    def setUp(self):
        self.api_client = TestApiClient(CinelabSerializer())
        self.get_credentials()
        self.copy_project_json = json.dumps({
            "meta": {
                     "dc:creator": "admin",
                     "dc:contributor": "admin",
                     "dc:title": "New title TEST",
                     "dc:created":"2015-07-21T10:10:09Z",
                     "dc:modified":"2015-07-21T10:10:09Z",
                     "dc:description": "New description TEST",
                     "iricle:status": 3
            },
            "views": [],
            "lists": [],
            "annotation-types": [],
            "medias": [],
            "tags": [],
            "annotations": []
        })


    def tearDown(self):
        pass

    def testCopy(self):
        resp = self.api_client.client.post("%s?source=c0bc66fa-2eca-11e5-a518-58b035f6b93d" % reverse('api_dispatch_list',kwargs={'api_name':'1.0', 'resource_name':'projects'}), content_type='application/cinelab', data=self.copy_project_json)
        self.assertHttpCreated(resp)
        location = resp['Location']
        self.assertIsNotNone(location, "Location should not be null")
        ldt_id = location.split('/')[-2]
        self.assertRegexpMatches(ldt_id, "[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}", "should match a guid")
        
        self.assertEqual(3, Project.objects.count(), "should have 3 projects now" )
        
        project = Project.objects.get(ldt_id=ldt_id)
        
        self.assertEqual("New title TEST", project.title, "title must be New title TEST and is : %s" % project.title)
        self.assertEqual("New description TEST", project.description, "description must be New description TEST and is : %s" % project.description)
        self.assertEqual(3, project.state, "status must be 3 and is : %r " % project.state)
        
    def testContentType(self):
        resp = self.api_client.client.post("%s?source=c0bc66fa-2eca-11e5-a518-58b035f6b93d" % reverse('api_dispatch_list',kwargs={'api_name':'1.0', 'resource_name':'projects'}), content_type='application/json', data=self.copy_project_json)
        self.assertHttpBadRequest(resp)
